/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import org.geotools.factory.BufferedFactory;
import org.geotools.factory.Hints;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;

public class BufferedCoordinateOperationFactory
extends AbstractCoordinateOperationFactory
implements BufferedFactory {
    static final int PRIORITY = 70;
    private CoordinateOperationFactory factory;
    private final Map<CRSPair, CoordinateOperation> pool = new SoftValueHashMap<CRSPair, CoordinateOperation>();

    public BufferedCoordinateOperationFactory() {
        super(null, 70);
    }

    public BufferedCoordinateOperationFactory(Hints hints) {
        this(hints, 70);
    }

    public BufferedCoordinateOperationFactory(Hints hints, int n) {
        this(BufferedCoordinateOperationFactory.getBackingFactory(hints), hints, n);
    }

    private BufferedCoordinateOperationFactory(CoordinateOperationFactory coordinateOperationFactory, Hints hints, int n) {
        super(coordinateOperationFactory, hints, n);
        this.factory = coordinateOperationFactory;
        BufferedCoordinateOperationFactory.ensureNonNull("factory", coordinateOperationFactory);
    }

    private static CoordinateOperationFactory getBackingFactory(Hints hints) {
        for (CoordinateOperationFactory coordinateOperationFactory : ReferencingFactoryFinder.getCoordinateOperationFactories(hints)) {
            if (coordinateOperationFactory instanceof BufferedCoordinateOperationFactory) continue;
            return coordinateOperationFactory;
        }
        return ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
    }

    private final CoordinateOperationFactory getBackingFactory() {
        assert (Thread.holdsLock(this.hints));
        if (this.factory == null) {
            this.factory = BufferedCoordinateOperationFactory.getBackingFactory(null);
        }
        return this.factory;
    }

    @Override
    void initializeHints() {
        super.initializeHints();
        this.hints.put(Hints.COORDINATE_OPERATION_FACTORY, this.getBackingFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws OperationNotFoundException, FactoryException {
        CoordinateOperation coordinateOperation;
        BufferedCoordinateOperationFactory.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        BufferedCoordinateOperationFactory.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        CRSPair cRSPair = new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2);
        Map map = this.hints;
        synchronized (map) {
            coordinateOperation = this.pool.get(cRSPair);
            if (coordinateOperation == null) {
                coordinateOperation = this.getBackingFactory().createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
                this.pool.put(cRSPair, coordinateOperation);
            }
        }
        return coordinateOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, OperationMethod operationMethod) throws OperationNotFoundException, FactoryException {
        Map map = this.hints;
        synchronized (map) {
            return this.getBackingFactory().createOperation(coordinateReferenceSystem, coordinateReferenceSystem2, operationMethod);
        }
    }

    private static final class CRSPair {
        private final int hash;
        private final CoordinateReferenceSystem sourceCRS;
        private final CoordinateReferenceSystem targetCRS;

        public CRSPair(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
            this.sourceCRS = coordinateReferenceSystem;
            this.targetCRS = coordinateReferenceSystem2;
            this.hash = 37 * coordinateReferenceSystem.hashCode() + coordinateReferenceSystem2.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CRSPair) {
                CRSPair cRSPair = (CRSPair)object;
                return Utilities.equals(this.sourceCRS, cRSPair.sourceCRS) && Utilities.equals(this.targetCRS, cRSPair.targetCRS);
            }
            return false;
        }
    }
}

