/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.DerivedSet;
import org.geotools.util.NameFactory;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class PropertyAuthorityFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory {
    private final Citation authority;
    private final Citation[] authorities;
    private final Properties definitions = new Properties();
    private final Set<String> codes = Collections.unmodifiableSet(this.definitions.keySet());
    private transient Map<Class<? extends IdentifiedObject>, Set<String>> filteredCodes;
    private transient Parser parser;

    public PropertyAuthorityFactory(ReferencingFactoryContainer referencingFactoryContainer, Citation[] citationArray, URL uRL) throws IOException {
        super(referencingFactoryContainer, 11);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
        PropertyAuthorityFactory.ensureNonNull("authorities", citationArray);
        if (citationArray.length == 0) {
            throw new IllegalArgumentException(Errors.format(46));
        }
        this.authorities = (Citation[])citationArray.clone();
        this.authority = citationArray[0];
        PropertyAuthorityFactory.ensureNonNull("authority", this.authority);
        InputStream inputStream = uRL.openStream();
        this.definitions.load(inputStream);
        inputStream.close();
        Symbols symbols = Symbols.DEFAULT;
        for (Object object : this.definitions.values()) {
            if (!symbols.containsAxis((String)object)) continue;
            LOGGER.warning("Axis elements found in a wkt definition, the force longitude first axis order hint might not be respected:\n" + object);
            return;
        }
        this.hints.remove(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        if (clazz == null || clazz.isAssignableFrom(IdentifiedObject.class)) {
            return this.codes;
        }
        if (this.filteredCodes == null) {
            this.filteredCodes = new HashMap<Class<? extends IdentifiedObject>, Set<String>>();
        }
        Map<Class<? extends IdentifiedObject>, Set<String>> map = this.filteredCodes;
        synchronized (map) {
            Codes codes = this.filteredCodes.get(clazz);
            if (codes == null) {
                Properties properties = this.definitions;
                codes = new Codes(properties, clazz);
                this.filteredCodes.put(clazz, codes);
            }
            return codes;
        }
    }

    public String getWKT(String string) throws NoSuchAuthorityCodeException {
        PropertyAuthorityFactory.ensureNonNull("code", string);
        String string2 = this.definitions.getProperty(this.trimAuthority(string));
        if (string2 == null) {
            throw this.noSuchAuthorityCode(IdentifiedObject.class, string);
        }
        return string2.trim();
    }

    @Override
    public InternationalString getDescriptionText(String string) throws NoSuchAuthorityCodeException, FactoryException {
        int n;
        String string2 = this.getWKT(string);
        int n2 = string2.indexOf(34);
        if (n2 >= 0 && (n = string2.indexOf(34, ++n2)) >= 0) {
            return new SimpleInternationalString(string2.substring(n2, n).trim());
        }
        return null;
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.parser = new Parser();
        }
        return this.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdentifiedObject createObject(String string) throws NoSuchAuthorityCodeException, FactoryException {
        String string2 = this.getWKT(string);
        Parser parser = this.getParser();
        try {
            Parser parser2 = parser;
            synchronized (parser2) {
                parser.code = string;
                return (IdentifiedObject)parser.parseObject(string2);
            }
        }
        catch (ParseException parseException) {
            throw new FactoryException(parseException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws NoSuchAuthorityCodeException, FactoryException {
        String string2 = this.getWKT(string);
        Parser parser = this.getParser();
        try {
            Parser parser2 = parser;
            synchronized (parser2) {
                parser.code = string;
                return parser.parseCoordinateReferenceSystem(string2);
            }
        }
        catch (ParseException parseException) {
            throw new FactoryException(parseException);
        }
    }

    @Override
    protected String trimAuthority(String string) {
        GenericName genericName = NameFactory.create(string = string.trim());
        GenericName genericName2 = genericName.scope().name();
        if (genericName2 == null) {
            return string;
        }
        String string2 = ((Object)genericName2).toString();
        for (int i = 0; i < this.authorities.length; ++i) {
            if (!Citations.identifierMatches(this.authorities[i], string2)) continue;
            return ((Object)genericName.tip()).toString().trim();
        }
        return string;
    }

    private final class Parser
    extends org.geotools.referencing.wkt.Parser {
        private static final long serialVersionUID = -5910561042299146066L;
        String code;

        public Parser() {
            super(Symbols.DEFAULT, PropertyAuthorityFactory.this.factories);
        }

        @Override
        protected Map<String, Object> alterProperties(Map<String, Object> map) {
            Object object = map.get("identifiers");
            if (object == null && this.code != null) {
                NamedIdentifier[] namedIdentifierArray;
                map = new HashMap<String, Object>(map);
                this.code = PropertyAuthorityFactory.this.trimAuthority(this.code);
                if (PropertyAuthorityFactory.this.authorities.length <= 1) {
                    namedIdentifierArray = new NamedIdentifier(PropertyAuthorityFactory.this.authority, this.code);
                } else {
                    NamedIdentifier[] namedIdentifierArray2 = new NamedIdentifier[PropertyAuthorityFactory.this.authorities.length];
                    for (int i = 0; i < namedIdentifierArray2.length; ++i) {
                        namedIdentifierArray2[i] = new NamedIdentifier(PropertyAuthorityFactory.this.authorities[i], this.code);
                    }
                    namedIdentifierArray = namedIdentifierArray2;
                }
                map.put("identifiers", namedIdentifierArray);
            }
            return super.alterProperties(map);
        }
    }

    private static final class Codes
    extends DerivedSet<String, String> {
        private static final long serialVersionUID = 2681905294171687900L;
        private final Class<? extends IdentifiedObject> type;
        private final Map<String, String> definitions;

        public Codes(Map<String, String> map, Class<? extends IdentifiedObject> clazz) {
            super(map.keySet(), String.class);
            this.definitions = map;
            this.type = clazz;
        }

        @Override
        protected String baseToDerived(String string) {
            int n;
            String string2 = this.definitions.get(string);
            int n2 = string2.length();
            for (n = 0; n < n2 && Character.isJavaIdentifierPart(string2.charAt(n)); ++n) {
            }
            Class<Object> clazz = Parser.getClassOf(string2.substring(0, n));
            if (clazz == null) {
                clazz = IdentifiedObject.class;
            }
            return this.type.isAssignableFrom(clazz) ? string : null;
        }

        @Override
        protected String derivedToBase(String string) {
            return string;
        }
    }
}

