/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.unit.Unit;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public final class Parameters {
    private static final double EPS = 1.0E-8;
    public static ParameterDescriptorGroup EMPTY_GROUP = new DefaultParameterDescriptorGroup("empty", new GeneralParameterDescriptor[0]);

    private Parameters() {
    }

    public static <T> ParameterDescriptor<T> cast(ParameterDescriptor<?> parameterDescriptor, Class<T> clazz) throws ClassCastException {
        Class<?> clazz2;
        if (parameterDescriptor != null && !clazz.equals(clazz2 = parameterDescriptor.getValueClass())) {
            throw new ClassCastException(Errors.format(13, parameterDescriptor.getName().getCode(), clazz2));
        }
        return parameterDescriptor;
    }

    public static <T> ParameterValue<T> cast(ParameterValue<?> parameterValue, Class<T> clazz) throws ClassCastException {
        ParameterDescriptor<?> parameterDescriptor;
        Class<?> clazz2;
        if (parameterValue != null && !clazz.equals(clazz2 = (parameterDescriptor = parameterValue.getDescriptor()).getValueClass())) {
            throw new ClassCastException(Errors.format(13, parameterDescriptor.getName().getCode(), clazz2));
        }
        return parameterValue;
    }

    public static boolean ensureSet(ParameterValueGroup parameterValueGroup, String string, double d, Unit<?> unit, boolean bl) {
        ParameterValue<?> parameterValue;
        try {
            parameterValue = parameterValueGroup.parameter(string);
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            return false;
        }
        try {
            if (Math.abs(parameterValue.doubleValue(unit) / d - 1.0) <= 1.0E-8) {
                return false;
            }
        }
        catch (InvalidParameterTypeException invalidParameterTypeException) {
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            parameterValue.setValue(d, unit);
            return true;
        }
        if (bl) {
            parameterValue.setValue(d, unit);
        } else {
            LogRecord logRecord = new LogRecord(Level.FINE, "Axis length mismatch.");
            logRecord.setSourceClassName(Parameters.class.getName());
            logRecord.setSourceMethodName("ensureSet");
            Logger logger = Logging.getLogger(Parameters.class);
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
        return true;
    }
}

