/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReferencedEnvelope
extends Envelope
implements BoundingBox {
    public static ReferencedEnvelope EVERYTHING = new ReferencedEnvelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null){
        private static final long serialVersionUID = -3188702602373537164L;

        @Override
        public boolean contains(BoundingBox boundingBox) {
            return true;
        }

        public boolean contains(Coordinate coordinate) {
            return true;
        }

        @Override
        public boolean contains(DirectPosition directPosition) {
            return true;
        }

        public boolean contains(double d, double d2) {
            return true;
        }

        public boolean contains(Envelope envelope) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public boolean isNull() {
            return true;
        }

        public double getArea() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public void setBounds(BoundingBox boundingBox) {
            throw new IllegalStateException("Cannot modify ReferencedEnvelope.EVERYTHING");
        }

        public Coordinate centre() {
            return new Coordinate();
        }

        public void setToNull() {
        }

        @Override
        public boolean equals(Object object) {
            if (object == EVERYTHING) {
                return true;
            }
            if (object instanceof ReferencedEnvelope) {
                ReferencedEnvelope referencedEnvelope = (ReferencedEnvelope)object;
                if (referencedEnvelope.crs != EVERYTHING.crs) {
                    return false;
                }
                if (referencedEnvelope.getMinX() != EVERYTHING.getMinX()) {
                    return false;
                }
                if (referencedEnvelope.getMinY() != EVERYTHING.getMinY()) {
                    return false;
                }
                if (referencedEnvelope.getMaxX() != EVERYTHING.getMaxX()) {
                    return false;
                }
                return referencedEnvelope.getMaxY() == EVERYTHING.getMaxY();
            }
            return super.equals(object);
        }

        @Override
        public String toString() {
            return "ReferencedEnvelope.EVERYTHING";
        }
    };
    private static final long serialVersionUID = -3188702602373537163L;
    private CoordinateReferenceSystem crs;

    public ReferencedEnvelope() {
        this((CoordinateReferenceSystem)null);
    }

    public ReferencedEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        this.crs = coordinateReferenceSystem;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(double d, double d2, double d3, double d4, CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        super(d, d2, d3, d4);
        this.crs = coordinateReferenceSystem;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(BoundingBox boundingBox) throws MismatchedDimensionException {
        this(boundingBox.getMinX(), boundingBox.getMaxX(), boundingBox.getMinY(), boundingBox.getMaxY(), boundingBox.getCoordinateReferenceSystem());
    }

    public ReferencedEnvelope(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        super(envelope);
        this.crs = coordinateReferenceSystem;
        this.checkCoordinateReferenceSystemDimension();
    }

    public void init(BoundingBox boundingBox) {
        super.init(boundingBox.getMinimum(0), boundingBox.getMaximum(0), boundingBox.getMinimum(1), boundingBox.getMaximum(1));
        this.crs = boundingBox.getCoordinateReferenceSystem();
    }

    private static Envelope getJTSEnvelope(BoundingBox boundingBox) {
        if (boundingBox == null) {
            throw new NullPointerException("Provided bbox envelope was null");
        }
        if (boundingBox instanceof Envelope) {
            return (Envelope)boundingBox;
        }
        return new ReferencedEnvelope(boundingBox);
    }

    private void checkCoordinateReferenceSystemDimension() throws MismatchedDimensionException {
        if (this.crs != null) {
            int n = this.getDimension();
            int n2 = this.crs.getCoordinateSystem().getDimension();
            if (n2 != n) {
                throw new MismatchedDimensionException(Errors.format(94, this.crs.getName().getCode(), new Integer(n2), new Integer(n)));
            }
        }
    }

    private void ensureCompatibleReferenceSystem(BoundingBox boundingBox) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem coordinateReferenceSystem;
        if (this.crs != null && (coordinateReferenceSystem = boundingBox.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(this.crs, coordinateReferenceSystem)) {
            throw new MismatchedReferenceSystemException(Errors.format(92));
        }
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double getMinimum(int n) {
        switch (n) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    @Override
    public double getMaximum(int n) {
        switch (n) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    @Override
    public double getCenter(int n) {
        return this.getMedian(n);
    }

    @Override
    public double getMedian(int n) {
        switch (n) {
            case 0: {
                return 0.5 * (this.getMinX() + this.getMaxX());
            }
            case 1: {
                return 0.5 * (this.getMinY() + this.getMaxY());
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    @Override
    public double getLength(int n) {
        return this.getSpan(n);
    }

    @Override
    public double getSpan(int n) {
        switch (n) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    @Override
    public boolean isEmpty() {
        return super.isNull();
    }

    public boolean contains(DirectPosition directPosition) {
        return super.contains(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
    }

    public boolean contains(BoundingBox boundingBox) {
        this.ensureCompatibleReferenceSystem(boundingBox);
        return super.contains(ReferencedEnvelope.getJTSEnvelope(boundingBox));
    }

    public Envelope intersection(Envelope envelope) {
        if (envelope instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)envelope;
            this.ensureCompatibleReferenceSystem(boundingBox);
        }
        return super.intersection(envelope);
    }

    @Override
    public void include(BoundingBox boundingBox) {
        if (this.crs == null) {
            this.crs = boundingBox.getCoordinateReferenceSystem();
        } else {
            this.ensureCompatibleReferenceSystem(boundingBox);
        }
        super.expandToInclude(ReferencedEnvelope.getJTSEnvelope(boundingBox));
    }

    public void expandToInclude(Envelope envelope) {
        if (envelope instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)envelope;
            this.ensureCompatibleReferenceSystem(boundingBox);
        }
        super.expandToInclude(envelope);
    }

    @Override
    public void include(double d, double d2) {
        super.expandToInclude(d, d2);
    }

    public void setBounds(BoundingBox boundingBox) {
        this.ensureCompatibleReferenceSystem(boundingBox);
        super.init(ReferencedEnvelope.getJTSEnvelope(boundingBox));
    }

    public int hashCode() {
        int n = super.hashCode() ^ 0xAB296275;
        if (this.crs != null) {
            n ^= this.crs.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            CoordinateReferenceSystem coordinateReferenceSystem;
            CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateReferenceSystem = object instanceof ReferencedEnvelope ? ((ReferencedEnvelope)object).crs : null;
            if (coordinateReferenceSystem == null) {
                return this.crs == null;
            }
            return CRS.equalsIgnoreMetadata(this.crs, coordinateReferenceSystem);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(this)).append('[');
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getMinimum(i)).append(" : ").append(this.getMaximum(i));
        }
        return stringBuilder.append(']').toString();
    }

    public static ReferencedEnvelope reference(Envelope envelope) {
        if (envelope == null) {
            return null;
        }
        if (envelope instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)envelope;
        }
        return new ReferencedEnvelope(envelope, null);
    }

    public static ReferencedEnvelope reference(BoundingBox boundingBox) {
        if (boundingBox == null) {
            return null;
        }
        if (boundingBox instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)boundingBox;
        }
        return new ReferencedEnvelope(boundingBox);
    }
}

