/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import javax.measure.unit.NonSI;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class LambertAzimuthalEqualArea
extends MapProjection {
    private static final long serialVersionUID = 1639914708790574760L;
    private static final double EPSILON = 1.0E-7;
    private static final double FINE_EPSILON = 1.0E-10;
    private static final double EPSILON_LATITUDE = 1.0E-10;
    private static final double P00 = 0.3333333333333333;
    private static final double P01 = 0.17222222222222222;
    private static final double P02 = 0.10257936507936508;
    private static final double P10 = 0.06388888888888888;
    private static final double P11 = 0.0664021164021164;
    private static final double P20 = 0.016415012942191543;
    static final int OBLIQUE = 0;
    static final int EQUATORIAL = 1;
    static final int NORTH_POLE = 2;
    static final int SOUTH_POLE = 3;
    final int mode;
    final double sinb1;
    final double cosb1;
    final double xmf;
    final double ymf;
    final double mmf;
    final double qp;
    final double dd;
    final double rq;
    private final double APA0;
    private final double APA1;
    private final double APA2;

    protected LambertAzimuthalEqualArea(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        super(parameterValueGroup);
        List<GeneralParameterDescriptor> list = this.getParameterDescriptors().descriptors();
        this.latitudeOfOrigin = this.doubleValue(list, Provider.LATITUDE_OF_CENTRE, parameterValueGroup);
        this.centralMeridian = this.doubleValue(list, Provider.LONGITUDE_OF_CENTRE, parameterValueGroup);
        LambertAzimuthalEqualArea.ensureLatitudeInRange(Provider.LATITUDE_OF_CENTRE, this.latitudeOfOrigin, true);
        LambertAzimuthalEqualArea.ensureLongitudeInRange(Provider.LONGITUDE_OF_CENTRE, this.centralMeridian, true);
        double d = Math.abs(this.latitudeOfOrigin);
        this.mode = Math.abs(d - 1.5707963267948966) < 1.0E-10 ? (this.latitudeOfOrigin < 0.0 ? 3 : 2) : (Math.abs(d) < 1.0E-10 ? 1 : 0);
        double d2 = this.excentricitySquared * this.excentricitySquared;
        double d3 = this.excentricitySquared * d2;
        this.APA0 = 0.10257936507936508 * d3 + 0.17222222222222222 * d2 + 0.3333333333333333 * this.excentricitySquared;
        this.APA1 = 0.0664021164021164 * d3 + 0.06388888888888888 * d2;
        this.APA2 = 0.016415012942191543 * d3;
        this.qp = this.qsfn(1.0);
        this.rq = Math.sqrt(0.5 * this.qp);
        this.mmf = 0.5 / (1.0 - this.excentricitySquared);
        double d4 = Math.sin(this.latitudeOfOrigin);
        if (this.isSpherical) {
            this.sinb1 = Math.sin(this.latitudeOfOrigin);
            this.cosb1 = Math.cos(this.latitudeOfOrigin);
        } else {
            this.sinb1 = this.qsfn(d4) / this.qp;
            this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
        }
        switch (this.mode) {
            case 2: 
            case 3: {
                this.dd = 1.0;
                this.xmf = this.ymf = this.rq;
                break;
            }
            case 1: {
                this.dd = 1.0 / this.rq;
                this.xmf = 1.0;
                this.ymf = 0.5 * this.qp;
                break;
            }
            case 0: {
                this.dd = Math.cos(this.latitudeOfOrigin) / (Math.sqrt(1.0 - this.excentricitySquared * d4 * d4) * this.rq * this.cosb1);
                this.xmf = this.rq * this.dd;
                this.ymf = this.rq / this.dd;
                break;
            }
            default: {
                throw new AssertionError(this.mode);
            }
        }
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup parameterValueGroup = super.getParameterValues();
        List<GeneralParameterDescriptor> list = this.getParameterDescriptors().descriptors();
        this.set(list, Provider.LATITUDE_OF_CENTRE, parameterValueGroup, this.latitudeOfOrigin);
        this.set(list, Provider.LONGITUDE_OF_CENTRE, parameterValueGroup, this.centralMeridian);
        return parameterValueGroup;
    }

    @Override
    protected Point2D transformNormalized(double d, double d2, Point2D point2D) throws ProjectionException {
        double d3;
        double d4;
        double d5;
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = Math.sin(d2);
        double d9 = this.qsfn(d8);
        switch (this.mode) {
            case 0: {
                double d10 = d9 / this.qp;
                double d11 = Math.sqrt(1.0 - d10 * d10);
                d5 = 1.0 + this.sinb1 * d10 + this.cosb1 * d11 * d6;
                double d12 = Math.sqrt(2.0 / d5);
                d4 = this.ymf * d12 * (this.cosb1 * d10 - this.sinb1 * d11 * d6);
                d3 = this.xmf * d12 * d11 * d7;
                break;
            }
            case 1: {
                double d13 = d9 / this.qp;
                double d14 = Math.sqrt(1.0 - d13 * d13);
                d5 = 1.0 + d14 * d6;
                double d15 = Math.sqrt(2.0 / d5);
                d4 = this.ymf * d15 * d13;
                d3 = this.xmf * d15 * d14 * d7;
                break;
            }
            case 2: {
                d5 = 1.5707963267948966 + d2;
                d9 = this.qp - d9;
                if (d9 >= 0.0) {
                    double d16 = Math.sqrt(d9);
                    d3 = d16 * d7;
                    d4 = d6 * -d16;
                    break;
                }
                d4 = 0.0;
                d3 = 0.0;
                break;
            }
            case 3: {
                d5 = d2 - 1.5707963267948966;
                d9 = this.qp + d9;
                if (d9 >= 0.0) {
                    double d17 = Math.sqrt(d9);
                    d3 = d17 * d7;
                    d4 = d6 * d17;
                    break;
                }
                d4 = 0.0;
                d3 = 0.0;
                break;
            }
            default: {
                throw new AssertionError(this.mode);
            }
        }
        if (Math.abs(d5) < 1.0E-10) {
            throw new ProjectionException(168);
        }
        if (point2D != null) {
            point2D.setLocation(d3, d4);
            return point2D;
        }
        return new Point2D.Double(d3, d4);
    }

    @Override
    protected Point2D inverseTransformNormalized(double d, double d2, Point2D point2D) throws ProjectionException {
        double d3;
        double d4;
        switch (this.mode) {
            case 0: 
            case 1: {
                double d5;
                double d6 = Math.hypot(d /= this.dd, d2 *= this.dd);
                if (d6 < 1.0E-10) {
                    d4 = 0.0;
                    d3 = this.latitudeOfOrigin;
                    break;
                }
                double d7 = 2.0 * Math.asin(0.5 * d6 / this.rq);
                double d8 = Math.cos(d7);
                d7 = Math.sin(d7);
                d *= d7;
                if (this.mode == 0) {
                    d5 = d8 * this.sinb1 + d2 * d7 * this.cosb1 / d6;
                    d2 = d6 * this.cosb1 * d8 - d2 * this.sinb1 * d7;
                } else {
                    d5 = d2 * d7 / d6;
                    d2 = d6 * d8;
                }
                d4 = Math.atan2(d, d2);
                d3 = this.authlat(Math.asin(d5));
                break;
            }
            case 2: {
                d2 = -d2;
            }
            case 3: {
                double d9 = d * d + d2 * d2;
                if (d9 == 0.0) {
                    d4 = 0.0;
                    d3 = this.latitudeOfOrigin;
                    break;
                }
                double d10 = 1.0 - d9 / this.qp;
                if (this.mode == 3) {
                    d10 = -d10;
                }
                d4 = Math.atan2(d, d2);
                d3 = this.authlat(Math.asin(d10));
                break;
            }
            default: {
                throw new AssertionError(this.mode);
            }
        }
        if (point2D != null) {
            point2D.setLocation(d4, d3);
            return point2D;
        }
        return new Point2D.Double(d4, d3);
    }

    private double qsfn(double d) {
        if (this.excentricity >= 1.0E-7) {
            double d2 = this.excentricity * d;
            return (1.0 - this.excentricitySquared) * (d / (1.0 - d2 * d2) - 0.5 / this.excentricity * Math.log((1.0 - d2) / (1.0 + d2)));
        }
        return d + d;
    }

    private double authlat(double d) {
        double d2 = d + d;
        return d + this.APA0 * Math.sin(d2) + this.APA1 * Math.sin(d2 + d2) + this.APA2 * Math.sin(d2 + d2 + d2);
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 3877793025552244132L;
        public static final ParameterDescriptor LATITUDE_OF_CENTRE = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_center"), new NamedIdentifier(Citations.EPSG, "Latitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Spherical latitude of origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Origin"), new NamedIdentifier(Citations.GEOTIFF, "ProjCenterLat")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONGITUDE_OF_CENTRE = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "longitude_of_center"), new NamedIdentifier(Citations.EPSG, "Longitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Spherical longitude of origin"), new NamedIdentifier(Citations.ESRI, "Central_Meridian"), new NamedIdentifier(Citations.GEOTIFF, "ProjCenterLong")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Lambert_Azimuthal_Equal_Area"), new NamedIdentifier(Citations.EPSG, "Lambert Azimuthal Equal Area"), new NamedIdentifier(Citations.EPSG, "Lambert Azimuthal Equal Area (Spherical)"), new NamedIdentifier(Citations.GEOTIFF, "CT_LambertAzimEqualArea"), new NamedIdentifier(Citations.EPSG, "9820")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_CENTRE, LONGITUDE_OF_CENTRE, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            return Provider.isSpherical(parameterValueGroup) ? new Spherical(parameterValueGroup) : new LambertAzimuthalEqualArea(parameterValueGroup);
        }
    }

    private static final class Spherical
    extends LambertAzimuthalEqualArea {
        private static final long serialVersionUID = 2091431369806844342L;

        protected Spherical(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            super(parameterValueGroup);
            this.ensureSpherical();
        }

        @Override
        protected Point2D transformNormalized(double d, double d2, Point2D point2D) throws ProjectionException {
            double d3;
            double d4;
            assert ((point2D = super.transformNormalized(d, d2, point2D)) != null);
            double d5 = Math.sin(d2);
            double d6 = Math.cos(d2);
            double d7 = Math.cos(d);
            switch (this.mode) {
                case 1: {
                    d4 = 1.0 + d6 * d7;
                    if (d4 <= 1.0E-10) {
                        throw new ProjectionException(168);
                    }
                    d4 = Math.sqrt(2.0 / d4);
                    d3 = d4 * d6 * Math.sin(d);
                    d4 *= d5;
                    break;
                }
                case 0: {
                    d4 = 1.0 + this.sinb1 * d5 + this.cosb1 * d6 * d7;
                    if (d4 <= 1.0E-10) {
                        throw new ProjectionException(168);
                    }
                    d4 = Math.sqrt(2.0 / d4);
                    d3 = d4 * d6 * Math.sin(d);
                    d4 *= this.cosb1 * d5 - this.sinb1 * d6 * d7;
                    break;
                }
                case 2: {
                    if (Math.abs(d2 + this.latitudeOfOrigin) < 1.0E-10) {
                        throw new ProjectionException(168);
                    }
                    d4 = 0.7853981633974483 - d2 * 0.5;
                    d4 = 2.0 * Math.sin(d4);
                    d3 = d4 * Math.sin(d);
                    d4 *= -d7;
                    break;
                }
                case 3: {
                    if (Math.abs(d2 + this.latitudeOfOrigin) < 1.0E-10) {
                        throw new ProjectionException(168);
                    }
                    d4 = 0.7853981633974483 - d2 * 0.5;
                    d4 = 2.0 * Math.cos(d4);
                    d3 = d4 * Math.sin(d);
                    d4 *= d7;
                    break;
                }
                default: {
                    throw new AssertionError(this.mode);
                }
            }
            assert (Spherical.checkTransform(d3, d4, point2D));
            if (point2D != null) {
                point2D.setLocation(d3, d4);
                return point2D;
            }
            return new Point2D.Double(d3, d4);
        }

        @Override
        protected Point2D inverseTransformNormalized(double d, double d2, Point2D point2D) throws ProjectionException {
            double d3;
            assert ((point2D = super.inverseTransformNormalized(d, d2, point2D)) != null);
            double d4 = Math.hypot(d, d2);
            double d5 = d4 * 0.5;
            if (d5 > 1.0) {
                throw new ProjectionException(168);
            }
            d5 = 2.0 * Math.asin(d5);
            switch (this.mode) {
                case 1: {
                    double d6 = Math.sin(d5);
                    double d7 = Math.cos(d5);
                    d5 = Math.abs(d4) <= 1.0E-10 ? 0.0 : Math.asin(d2 * d6 / d4);
                    d2 = d7 * d4;
                    d3 = d2 == 0.0 ? 0.0 : Math.atan2(d *= d6, d2);
                    break;
                }
                case 0: {
                    double d8 = Math.sin(d5);
                    double d9 = Math.cos(d5);
                    d5 = Math.abs(d4) <= 1.0E-10 ? this.latitudeOfOrigin : Math.asin(d9 * this.sinb1 + d2 * d8 * this.cosb1 / d4);
                    d2 = (d9 - Math.sin(d5) * this.sinb1) * d4;
                    d3 = d2 == 0.0 ? 0.0 : Math.atan2(d *= d8 * this.cosb1, d2);
                    break;
                }
                case 2: {
                    d5 = 1.5707963267948966 - d5;
                    d3 = Math.atan2(d, -d2);
                    break;
                }
                case 3: {
                    d5 -= 1.5707963267948966;
                    d3 = Math.atan2(d, d2);
                    break;
                }
                default: {
                    throw new AssertionError(this.mode);
                }
            }
            assert (Spherical.checkInverseTransform(d3, d5, point2D));
            if (point2D != null) {
                point2D.setLocation(d3, d5);
                return point2D;
            }
            return new Point2D.Double(d3, d5);
        }
    }
}

