/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import org.geotools.referencing.operation.DefaultConicProjection;
import org.geotools.referencing.operation.DefaultCylindricalProjection;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultPlanarProjection;
import org.geotools.referencing.operation.DefaultProjection;
import org.geotools.referencing.operation.MathTransformProvider;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;

public class DefaultConversion
extends DefaultOperation
implements Conversion {
    private static final long serialVersionUID = -2148164324805562793L;

    public DefaultConversion(Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        super(conversion, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
    }

    public DefaultConversion(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
    }

    @Override
    void validate() throws IllegalArgumentException {
        if (this.transform != null || this.sourceCRS != null || this.targetCRS != null) {
            super.validate();
        }
    }

    public static Conversion create(Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, Class<? extends Conversion> clazz) {
        Class<? extends Operation> clazz2;
        Class<? extends CoordinateOperation> clazz3 = DefaultConversion.getType(conversion);
        OperationMethod operationMethod = conversion.getMethod();
        if (operationMethod instanceof MathTransformProvider && (clazz2 = ((MathTransformProvider)operationMethod).getOperationType()) != null && clazz3.isAssignableFrom(clazz2)) {
            clazz3 = clazz2;
        }
        if (clazz != null && clazz3.isAssignableFrom(clazz)) {
            clazz3 = clazz;
        }
        if (ConicProjection.class.isAssignableFrom(clazz3)) {
            return new DefaultConicProjection(conversion, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
        }
        if (CylindricalProjection.class.isAssignableFrom(clazz3)) {
            return new DefaultCylindricalProjection(conversion, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
        }
        if (PlanarProjection.class.isAssignableFrom(clazz3)) {
            return new DefaultPlanarProjection(conversion, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
        }
        if (Projection.class.isAssignableFrom(clazz3)) {
            return new DefaultProjection(conversion, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
        }
        return new DefaultConversion(conversion, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
    }
}

