/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.AbstractFactory;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.InternationalString;

public class EPSGCRSAuthorityFactory
extends AbstractFactory
implements CRSAuthorityFactory {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.referencing.crs.EPSGCRSAuthorityFactory");
    public static final String AUTHORITY = "EPSG";
    public static final String AUTHORITY_PREFIX = "EPSG:";
    protected static EPSGCRSAuthorityFactory DEFAULT;
    protected Properties epsg = new Properties();
    protected CRSFactory crsFactory;
    private Hashtable cache = new Hashtable();

    public EPSGCRSAuthorityFactory() {
        this(ReferencingFactoryFinder.getCRSFactory(null));
    }

    protected EPSGCRSAuthorityFactory(CRSFactory cRSFactory) {
        super(1);
        this.crsFactory = cRSFactory;
        try {
            this.loadDefault();
        }
        catch (IOException iOException) {
            System.err.println("Could not load epsg.properties" + iOException);
        }
    }

    protected EPSGCRSAuthorityFactory(CRSFactory cRSFactory, URL uRL) throws FactoryException {
        this(cRSFactory);
        try {
            this.epsg.load(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new FactoryException("Could not load properties file: " + uRL);
        }
    }

    protected void loadDefault() throws IOException {
        File file = new File("epsg.properties");
        if (file.exists()) {
            this.epsg.load(new FileInputStream(file));
        }
        URL uRL = EPSGCRSAuthorityFactory.class.getResource("epsg.properties");
        this.epsg.load(uRL.openStream());
    }

    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        Object object;
        if (string == null) {
            return null;
        }
        if (!string.startsWith(AUTHORITY_PREFIX)) {
            throw new NoSuchAuthorityCodeException("This factory only understand EPSG codes", AUTHORITY, string);
        }
        String string2 = string.substring(string.indexOf(58) + 1).trim();
        if (this.cache.containsKey(string2)) {
            object = this.cache.get(string2);
            if (object instanceof Throwable) {
                throw new FactoryException("WKT for " + string + " could not be parsed", (Throwable)object);
            }
            if (object instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)object;
            }
        }
        if ((object = this.epsg.getProperty(string2)) == null) {
            throw new NoSuchAuthorityCodeException("Unknown EPSG_NUMBER", AUTHORITY, string);
        }
        if (((String)object).indexOf(string2) == -1) {
            object = ((String)object).trim();
            object = ((String)object).substring(0, ((String)object).length() - 1);
            object = (String)object + ",AUTHORITY[\"EPSG\",\"" + string2 + "\"]]";
            LOGGER.log(Level.WARNING, AUTHORITY_PREFIX + string2 + " lacks a proper identifying authority in its Well-Known Text. It is being added programmatically.");
        }
        try {
            CoordinateReferenceSystem coordinateReferenceSystem = this.crsFactory.createFromWKT((String)object);
            this.cache.put(string2, coordinateReferenceSystem);
            return coordinateReferenceSystem;
        }
        catch (FactoryException factoryException) {
            this.cache.put(string2, factoryException);
            throw factoryException;
        }
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.createCoordinateReferenceSystem(string);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        return (ProjectedCRS)this.createCoordinateReferenceSystem(string);
    }

    @Override
    public GeographicCRS createGeographicCRS(String string) throws FactoryException {
        return (GeographicCRS)this.createCoordinateReferenceSystem(string);
    }

    @Override
    public Citation getAuthority() {
        return Citations.EPSG;
    }

    public Set getAuthorityCodes(Class clazz) throws FactoryException {
        if (clazz.getName().equalsIgnoreCase(CoordinateReferenceSystem.class.getName())) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string : this.epsg.keySet()) {
                treeSet.add(AUTHORITY_PREFIX + string);
            }
            return treeSet;
        }
        if (clazz.getName().equalsIgnoreCase(GeographicCRS.class.getName())) {
            Set<Object> set = this.epsg.keySet();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string : set) {
                String string2 = this.epsg.getProperty(string);
                if (!string2.startsWith("GEOGCS")) continue;
                treeSet.add(AUTHORITY_PREFIX + string);
            }
            return treeSet;
        }
        if (clazz.getName().equalsIgnoreCase(ProjectedCRS.class.getName())) {
            Set<Object> set = this.epsg.keySet();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string : set) {
                String string3 = this.epsg.getProperty(string);
                if (!string3.startsWith("PROJCS")) continue;
                treeSet.add(AUTHORITY_PREFIX + string);
            }
            return treeSet;
        }
        return new TreeSet();
    }

    public ObjectFactory getObjectFactory() {
        return this.crsFactory;
    }

    @Override
    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        String string2;
        if (string == null) {
            return null;
        }
        if (string.startsWith(AUTHORITY_PREFIX)) {
            string = string.substring(5);
        }
        if ((string2 = this.epsg.getProperty(string = string.trim())) == null) {
            throw new FactoryException("Unknonwn EPSG code: '" + string + "'");
        }
        string2 = string2.trim();
        int n = string2.indexOf(34);
        int n2 = string2.indexOf(34, n + 1);
        return new SimpleInternationalString(string2.substring(n + 1, n2));
    }

    @Override
    public CompoundCRS createCompoundCRS(String string) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    @Override
    public DerivedCRS createDerivedCRS(String string) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String string) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String string) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    @Override
    public ImageCRS createImageCRS(String string) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    @Override
    public TemporalCRS createTemporalCRS(String string) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    @Override
    public VerticalCRS createVerticalCRS(String string) throws FactoryException {
        throw new FactoryException("Not implemented");
    }
}

