/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.geotools.data.shapefile.shp.ShapeType;

public class ShapefileHeader {
    public static final int MAGIC = 9994;
    public static final int VERSION = 1000;
    private int fileCode = -1;
    private int fileLength = -1;
    private int version = -1;
    private ShapeType shapeType = ShapeType.UNDEFINED;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    private void checkMagic(boolean bl) throws IOException {
        if (this.fileCode != 9994) {
            String string = "Wrong magic number, expected 9994, got " + this.fileCode;
            if (!bl) {
                System.err.println(string);
            } else {
                throw new IOException(string);
            }
        }
    }

    private void checkVersion(boolean bl) throws IOException {
        if (this.version != 1000) {
            String string = "Wrong version, expected 9994, got " + this.version;
            if (!bl) {
                System.err.println(string);
            } else {
                throw new IOException(string);
            }
        }
    }

    public void read(ByteBuffer byteBuffer, boolean bl) throws IOException {
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.fileCode = byteBuffer.getInt();
        this.checkMagic(bl);
        byteBuffer.position(byteBuffer.position() + 20);
        this.fileLength = byteBuffer.getInt();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.version = byteBuffer.getInt();
        this.checkVersion(bl);
        this.shapeType = ShapeType.forID(byteBuffer.getInt());
        this.minX = byteBuffer.getDouble();
        this.minY = byteBuffer.getDouble();
        this.maxX = byteBuffer.getDouble();
        this.maxY = byteBuffer.getDouble();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.position(byteBuffer.position() + 32);
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public double minX() {
        return this.minX;
    }

    public double minY() {
        return this.minY;
    }

    public double maxX() {
        return this.maxX;
    }

    public double maxY() {
        return this.maxY;
    }

    public String toString() {
        String string = new String("ShapeFileHeader[ size " + this.fileLength + " version " + this.version + " shapeType " + this.shapeType + " bounds " + this.minX + "," + this.minY + "," + this.maxX + "," + this.maxY + " ]");
        return string;
    }
}

