/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.FIDReader;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.resources.NIOUtilities;
import org.geotools.util.logging.Logging;

public class IndexedFidReader
implements FIDReader,
FileReader {
    public static final int HEADER_SIZE = 13;
    public static final int RECORD_SIZE = 12;
    private static final Logger LOGGER = Logging.getLogger("org.geotools.data.shapefile");
    private ReadableByteChannel readChannel;
    private ByteBuffer buffer;
    private long count;
    private String typeName;
    private boolean done;
    private int removes;
    private int currentShxIndex = -1;
    private RecordNumberTracker reader;
    private long currentId;
    private StringBuilder fidBuilder;
    private long bufferStart = Long.MIN_VALUE;
    StreamLogging streamLogger = new StreamLogging("IndexedFidReader");

    public IndexedFidReader(ShpFiles shpFiles) throws IOException {
        this.init(shpFiles, shpFiles.getReadChannel(ShpFileType.FIX, this));
    }

    public IndexedFidReader(ShpFiles shpFiles, RecordNumberTracker recordNumberTracker) throws IOException {
        this(shpFiles);
        this.reader = recordNumberTracker;
    }

    private void init(ShpFiles shpFiles, ReadableByteChannel readableByteChannel) throws IOException {
        this.typeName = shpFiles.getTypeName() + ".";
        this.fidBuilder = new StringBuilder(this.typeName);
        this.readChannel = readableByteChannel;
        this.streamLogger.open();
        this.getHeader(shpFiles);
        this.buffer = NIOUtilities.allocate(12288);
        this.buffer.position(this.buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHeader(ShpFiles shpFiles) throws IOException {
        block9: {
            ByteBuffer byteBuffer = NIOUtilities.allocate(13);
            try {
                ShapefileReader.fill(byteBuffer, this.readChannel);
                if (byteBuffer.position() == 0) {
                    this.done = true;
                    this.count = 0L;
                    return;
                }
                byteBuffer.position(0);
                byte by = byteBuffer.get();
                if (by != 1) {
                    throw new IOException("File is not of a compatible version for this reader or file is corrupt.");
                }
                this.count = byteBuffer.getLong();
                this.removes = byteBuffer.getInt();
                if ((long)this.removes <= this.getCount() / 2L) break block9;
                URL uRL = shpFiles.acquireRead(ShpFileType.FIX, this);
                try {
                    DataUtilities.urlToFile(uRL).deleteOnExit();
                }
                finally {
                    shpFiles.unlockRead(uRL, this);
                }
            }
            finally {
                NIOUtilities.clean(byteBuffer, false);
            }
        }
    }

    public long getCount() {
        return this.count;
    }

    public long findFid(String string) throws IOException {
        try {
            int n = this.typeName.length();
            long l = -1L;
            if (string.startsWith(this.typeName)) {
                try {
                    l = Long.parseLong(string.substring(n), 10);
                }
                catch (NumberFormatException numberFormatException) {
                    return -1L;
                }
            } else {
                return -1L;
            }
            if (l < 0L) {
                return -1L;
            }
            if (l < this.count) {
                return this.search(l, -1L, this.count, l - 1L);
            }
            return this.search(l, -1L, this.count, this.count - 1L);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warning("Fid is not recognized as a fid for this shapefile: " + this.typeName);
            return -1L;
        }
    }

    long search(long l, long l2, long l3, long l4) throws IOException {
        if (l2 == l3) {
            return -1L;
        }
        this.goTo(l4);
        this.hasNext();
        this.next();
        this.buffer.limit(this.buffer.capacity());
        if (this.currentId == l) {
            return this.currentShxIndex;
        }
        if (l3 - l2 < 10L) {
            return this.search(l, l2 + 1L, l3, l2 + 1L);
        }
        long l5 = l - this.currentId;
        long l6 = l4 + l5;
        if (l6 <= l2) {
            l6 = l2 + (l4 - l2) / 2L;
        }
        if (l6 >= l3) {
            l6 = l4 + (l3 - l4) / 2L;
        }
        if (l6 == l4) {
            return -1L;
        }
        if (l6 < l4) {
            return this.search(l, l2, l4, l6);
        }
        return this.search(l, l4, l3, l6);
    }

    public void goTo(long l) throws IOException {
        assert (l < this.count);
        if (this.readChannel instanceof FileChannel) {
            long l2 = 13L + l * 12L;
            if (l2 >= this.bufferStart + (long)this.buffer.limit() || l2 < this.bufferStart) {
                FileChannel fileChannel = (FileChannel)this.readChannel;
                fileChannel.position(l2);
                this.buffer.limit(this.buffer.capacity());
                this.buffer.position(this.buffer.limit());
            } else {
                this.buffer.position((int)(l2 - this.bufferStart));
            }
        } else {
            throw new IOException("Read Channel is not a File Channel so this is not possible.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.buffer != null) {
                NIOUtilities.clean(this.buffer, false);
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        finally {
            this.buffer = null;
            this.reader = null;
            this.readChannel.close();
            this.streamLogger.close();
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.done) {
            return false;
        }
        if (this.buffer.position() == this.buffer.limit()) {
            this.buffer.position(0);
            FileChannel fileChannel = (FileChannel)this.readChannel;
            this.bufferStart = fileChannel.position();
            int n = ShapefileReader.fill(this.buffer, this.readChannel);
            if (n != 0) {
                this.buffer.position(0);
            }
        }
        return this.buffer.remaining() != 0;
    }

    @Override
    public String next() throws IOException {
        if (this.reader != null) {
            this.goTo(this.reader.getRecordNumber() - 1);
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("Feature could not be read; a the index may be invalid");
        }
        this.currentId = this.buffer.getLong();
        this.currentShxIndex = this.buffer.getInt();
        this.fidBuilder.setLength(this.typeName.length());
        this.fidBuilder.append(this.currentId);
        return this.fidBuilder.toString();
    }
}

