/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.io.Serializable;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;

public final class Dimension
implements Serializable {
    private static Model CurrentModel = Model.STANDARD;
    public static final Dimension NONE = new Dimension(Unit.ONE);
    public static final Dimension LENGTH = new Dimension('L');
    public static final Dimension TIME = new Dimension('T');
    private final Unit<?> _pseudoUnit;
    private static final long serialVersionUID = 1L;

    public Dimension(char c) {
        this._pseudoUnit = new BaseUnit("[" + c + "]");
    }

    private Dimension(Unit<?> unit) {
        this._pseudoUnit = unit;
    }

    public final Dimension times(Dimension dimension) {
        return new Dimension(this._pseudoUnit.times(dimension._pseudoUnit));
    }

    public final Dimension pow(int n) {
        return new Dimension(this._pseudoUnit.pow(n));
    }

    public final Dimension root(int n) {
        return new Dimension(this._pseudoUnit.root(n));
    }

    public String toString() {
        return this._pseudoUnit.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof Dimension && this._pseudoUnit.equals(((Dimension)object)._pseudoUnit);
    }

    public int hashCode() {
        return this._pseudoUnit.hashCode();
    }

    public static Model getModel() {
        return CurrentModel;
    }

    public static interface Model {
        public static final Model STANDARD = new Model(){

            @Override
            public Dimension getDimension(BaseUnit<?> baseUnit) {
                if (baseUnit.equals(SI.METRE)) {
                    return LENGTH;
                }
                if (baseUnit.equals(SI.SECOND)) {
                    return TIME;
                }
                return new Dimension(new BaseUnit("[" + baseUnit.getSymbol() + "]"));
            }

            @Override
            public UnitConverter getTransform(BaseUnit<?> baseUnit) {
                return UnitConverter.IDENTITY;
            }
        };

        public Dimension getDimension(BaseUnit<?> var1);

        public UnitConverter getTransform(BaseUnit<?> var1);
    }
}

