/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.util.HashMap;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.DerivedUnit;
import javax.measure.unit.Unit;

public final class AlternateUnit<Q extends Quantity>
extends DerivedUnit<Q> {
    private final String _symbol;
    private final Unit<?> _parent;
    private static final long serialVersionUID = 1L;

    AlternateUnit(String string, Unit<?> unit) {
        if (!unit.isStandardUnit()) {
            throw new UnsupportedOperationException(this + " is not a standard unit");
        }
        this._symbol = string;
        this._parent = unit;
        HashMap<String, Unit<?>> hashMap = Unit.SYMBOL_TO_UNIT;
        synchronized (hashMap) {
            Unit<?> unit2 = Unit.SYMBOL_TO_UNIT.get(string);
            if (unit2 == null) {
                Unit.SYMBOL_TO_UNIT.put(string, this);
                return;
            }
            if (unit2 instanceof AlternateUnit) {
                AlternateUnit alternateUnit = (AlternateUnit)unit2;
                if (string.equals(alternateUnit._symbol) && this._parent.equals(alternateUnit._parent)) {
                    return;
                }
            }
            throw new IllegalArgumentException("Symbol " + string + " is associated to a different unit");
        }
    }

    public final Unit<? super Q> getParent() {
        return this._parent;
    }

    @Override
    public final Unit<? super Q> getStandardUnit() {
        return this;
    }

    @Override
    public final UnitConverter toStandardUnit() {
        return UnitConverter.IDENTITY;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AlternateUnit)) {
            return false;
        }
        AlternateUnit alternateUnit = (AlternateUnit)object;
        return this._symbol.equals(alternateUnit._symbol);
    }

    @Override
    public int hashCode() {
        return this._symbol.hashCode();
    }
}

