/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import javax.vecmath.Matrix4d;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.operation.Matrix;

public class Matrix4
extends Matrix4d
implements XMatrix {
    private static final long serialVersionUID = 5685762518066856310L;
    public static final int SIZE = 4;

    public Matrix4() {
        this.setIdentity();
    }

    public Matrix4(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        super(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16);
    }

    public Matrix4(Matrix matrix) {
        if (matrix.getNumRow() != 4 || matrix.getNumCol() != 4) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.setElement(i, j, matrix.getElement(i, j));
            }
        }
    }

    @Override
    public final int getNumRow() {
        return 4;
    }

    @Override
    public final int getNumCol() {
        return 4;
    }

    @Override
    public final boolean isIdentity() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.getElement(i, j) == (double)(j == i ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean isIdentity(double d) {
        return GeneralMatrix.isIdentity(this, d);
    }

    @Override
    public final boolean isAffine() {
        return this.m30 == 0.0 && this.m31 == 0.0 && this.m32 == 0.0 && this.m33 == 1.0;
    }

    @Override
    public final void multiply(Matrix matrix) {
        Matrix4d matrix4d = matrix instanceof Matrix4d ? (Matrix4d)((Object)matrix) : new Matrix4(matrix);
        this.mul(matrix4d);
    }

    @Override
    public boolean equals(Matrix matrix, double d) {
        return GeneralMatrix.epsilonEquals(this, matrix, d);
    }

    @Override
    public String toString() {
        return GeneralMatrix.toString(this);
    }

    @Override
    public Matrix4 clone() {
        return (Matrix4)super.clone();
    }
}

