/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.PropertyAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;

public class FactoryUsingWKT
extends DeferredAuthorityFactory
implements CRSAuthorityFactory {
    private Citation authority;
    public static final String FILENAME = "epsg.properties";
    private final ReferencingFactoryContainer factories;
    protected static final int DEFAULT_PRIORITY = 80;
    private final File directory;

    public FactoryUsingWKT() {
        this(null);
    }

    public FactoryUsingWKT(Hints hints) {
        this(hints, 80);
    }

    protected FactoryUsingWKT(Hints hints, int n) {
        super(hints, n);
        this.factories = ReferencingFactoryContainer.instance(hints);
        Object object = null;
        if (hints != null) {
            object = hints.get(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        }
        this.directory = object instanceof File ? (File)object : (object instanceof String ? new File((String)object) : null);
        this.hints.put(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, this.directory);
        this.setTimeout(900000L);
    }

    @Override
    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            Citation[] citationArray = this.getAuthorities();
            switch (citationArray.length) {
                case 0: {
                    this.authority = Citations.EPSG;
                    break;
                }
                case 1: {
                    this.authority = citationArray[0];
                    break;
                }
                default: {
                    CitationImpl citationImpl = new CitationImpl(citationArray[0]);
                    Collection<Identifier> collection = citationImpl.getIdentifiers();
                    for (int i = 1; i < citationArray.length; ++i) {
                        collection.addAll(citationArray[i].getIdentifiers());
                    }
                    citationImpl.freeze();
                    this.authority = citationImpl;
                    break;
                }
            }
        }
        return this.authority;
    }

    protected Citation[] getAuthorities() {
        return new Citation[]{Citations.EPSG};
    }

    protected URL getDefinitionsURL() {
        try {
            File file;
            if (this.directory != null && (file = new File(this.directory, FILENAME)).isFile()) {
                return file.toURI().toURL();
            }
        }
        catch (SecurityException securityException) {
            Logging.unexpectedException(LOGGER, securityException);
        }
        catch (MalformedURLException malformedURLException) {
            Logging.unexpectedException(LOGGER, malformedURLException);
        }
        return FactoryUsingWKT.class.getResource(FILENAME);
    }

    @Override
    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        try {
            URL uRL = this.getDefinitionsURL();
            if (uRL == null) {
                throw new FactoryNotFoundException(Errors.format(50, FILENAME));
            }
            Iterator<? extends Identifier> iterator = this.getAuthority().getIdentifiers().iterator();
            String string = iterator.hasNext() ? iterator.next().getCode() : "EPSG";
            LogRecord logRecord = Loggings.format(Level.CONFIG, 49, uRL.getPath(), string);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
            return new PropertyAuthorityFactory(this.factories, this.getAuthorities(), uRL);
        }
        catch (IOException iOException) {
            throw new FactoryException(Errors.format(28, FILENAME), iOException);
        }
    }
}

