/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.referencing.factory.FallbackAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.InternationalString;

public class ManyAuthoritiesFactory
extends AuthorityFactoryAdapter
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private static final Class<? extends AuthorityFactory>[] FACTORY_TYPES = new Class[]{CRSAuthorityFactory.class, DatumAuthorityFactory.class, CSAuthorityFactory.class, CoordinateOperationAuthorityFactory.class};
    private static final Class<? extends IdentifiedObject>[] OBJECT_TYPES = new Class[]{CoordinateReferenceSystem.class, Datum.class, CoordinateSystem.class, CoordinateOperation.class};
    private Collection<AuthorityFactory> factories;
    private final ThreadLocal<Boolean> inProgress = new ThreadLocal();

    public ManyAuthoritiesFactory(Collection<? extends AuthorityFactory> collection) {
        super(50);
        if (collection != null && !collection.isEmpty()) {
            for (AuthorityFactory authorityFactory : collection) {
                if (!(authorityFactory instanceof Factory)) continue;
                this.hints.putAll(((Factory)((Object)authorityFactory)).getImplementationHints());
            }
            this.factories = ManyAuthoritiesFactory.createFallbacks(collection);
        }
    }

    Collection<AuthorityFactory> getFactories() {
        return this.factories;
    }

    private static Collection<AuthorityFactory> createFallbacks(Collection<? extends AuthorityFactory> collection) {
        Object object;
        int n = 0;
        Citation[] citationArray = new Citation[collection.size()];
        List[] listArray = new List[citationArray.length];
        for (AuthorityFactory object22 : collection) {
            int n2;
            Object i = object22.getAuthority();
            for (n2 = 0; n2 < n; ++n2) {
                object = citationArray[n2];
                if (!Citations.identifierMatches((Citation)object, (Citation)i)) continue;
                i = object;
                break;
            }
            if (n2 == n) {
                citationArray[n++] = i;
                object = new ArrayList<AuthorityFactory>(4);
                listArray[n2] = object;
            } else {
                object = listArray[n2];
            }
            if (object.contains(object22)) continue;
            object.add(object22);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<AuthorityFactory> arrayList2 = new ArrayList<AuthorityFactory>(4);
        for (int i = 0; i < n; ++i) {
            List list = listArray[i];
            while (!list.isEmpty()) {
                object = null;
                boolean bl = false;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AuthorityFactory authorityFactory = (AuthorityFactory)iterator.next();
                    if (object == null) {
                        object = authorityFactory;
                    } else if (!FallbackAuthorityFactory.chainable(object, authorityFactory)) {
                        bl = true;
                        continue;
                    }
                    arrayList2.add(authorityFactory);
                    if (bl) continue;
                    iterator.remove();
                }
                arrayList.add(FallbackAuthorityFactory.create(arrayList2));
                arrayList2.clear();
            }
        }
        arrayList.trimToSize();
        return arrayList;
    }

    @Override
    boolean sameAuthorityCodes(AuthorityFactory authorityFactory) {
        return authorityFactory == this;
    }

    protected char getSeparator(String string) {
        string = string.trim();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            if (!string.regionMatches(i, "://", 0, 3)) break;
            return '/';
        }
        return ':';
    }

    private static boolean canSeparateAt(String string, int n) {
        char c;
        int n2 = n;
        do {
            if (--n2 >= 0) continue;
            return false;
        } while (Character.isWhitespace(c = string.charAt(n2)));
        if (!Character.isJavaIdentifierPart(c)) {
            return false;
        }
        int n3 = string.length();
        n2 = n;
        do {
            if (++n2 < n3) continue;
            return false;
        } while (Character.isWhitespace(c = string.charAt(n2)));
        return Character.isJavaIdentifierPart(c);
    }

    @Override
    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    @Override
    public Citation getAuthority() {
        return ALL;
    }

    public Set<String> getAuthorityNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Collection<AuthorityFactory> collection = this.getFactories();
        if (collection != null) {
            for (AuthorityFactory authorityFactory : collection) {
                hashSet.add(Citations.getIdentifier(authorityFactory.getAuthority()));
            }
        }
        return hashSet;
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        return null;
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        return this.getFactories();
    }

    private static boolean exclude(AuthorityFactory authorityFactory) {
        if (ManyAuthoritiesFactory.class.isInstance(authorityFactory)) {
            return true;
        }
        if (authorityFactory instanceof AuthorityFactoryAdapter) {
            AuthorityFactoryAdapter authorityFactoryAdapter = (AuthorityFactoryAdapter)authorityFactory;
            return ManyAuthoritiesFactory.exclude(authorityFactoryAdapter.crsFactory) || ManyAuthoritiesFactory.exclude(authorityFactoryAdapter.csFactory) || ManyAuthoritiesFactory.exclude(authorityFactoryAdapter.datumFactory) || ManyAuthoritiesFactory.exclude(authorityFactoryAdapter.operationFactory);
        }
        return false;
    }

    <T extends AuthorityFactory> T fromFactoryRegistry(String string, Class<T> clazz) throws FactoryRegistryException {
        return null;
    }

    @Override
    final <T extends AuthorityFactory> T getAuthorityFactory(Class<T> clazz, String string) throws NoSuchAuthorityCodeException {
        ManyAuthoritiesFactory.ensureNonNull("code", string);
        String string2 = null;
        FactoryRegistryException factoryRegistryException = null;
        Collection<AuthorityFactory> collection = this.getFactories();
        char c = this.getSeparator(string);
        int n = string.lastIndexOf(c);
        while (n >= 0) {
            block7: {
                if (ManyAuthoritiesFactory.canSeparateAt(string, n)) {
                    Iterator<AuthorityFactory> iterator;
                    string2 = string.substring(0, n).trim();
                    if (collection != null) {
                        for (AuthorityFactory authorityFactory : collection) {
                            if (!clazz.isAssignableFrom(authorityFactory.getClass()) || !Citations.identifierMatches(authorityFactory.getAuthority(), string2)) continue;
                            return (T)((AuthorityFactory)clazz.cast(authorityFactory));
                        }
                    }
                    try {
                        iterator = this.fromFactoryRegistry(string2, clazz);
                    }
                    catch (FactoryRegistryException factoryRegistryException2) {
                        factoryRegistryException = factoryRegistryException2;
                        break block7;
                    }
                    if (iterator != null) {
                        return (T)((AuthorityFactory)clazz.cast(iterator));
                    }
                }
            }
            n = string.lastIndexOf(c, n - 1);
        }
        throw this.noSuchAuthority(string, string2, factoryRegistryException);
    }

    private NoSuchAuthorityCodeException noSuchAuthority(String string, String string2, FactoryRegistryException factoryRegistryException) {
        String string3;
        if (string2 == null) {
            string2 = Vocabulary.format(230);
            string3 = Errors.format(96, string);
        } else {
            string3 = Errors.format(180, string2);
        }
        NoSuchAuthorityCodeException noSuchAuthorityCodeException = new NoSuchAuthorityCodeException(string3, string2, string);
        noSuchAuthorityCodeException.initCause(factoryRegistryException);
        return noSuchAuthorityCodeException;
    }

    @Override
    protected AuthorityFactory getAuthorityFactory(String string) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(AuthorityFactory.class, string);
    }

    @Override
    protected DatumAuthorityFactory getDatumAuthorityFactory(String string) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(DatumAuthorityFactory.class, string);
    }

    @Override
    protected CSAuthorityFactory getCSAuthorityFactory(String string) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(CSAuthorityFactory.class, string);
    }

    @Override
    protected CRSAuthorityFactory getCRSAuthorityFactory(String string) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(CRSAuthorityFactory.class, string);
    }

    @Override
    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String string) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(CoordinateOperationAuthorityFactory.class, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        if (Boolean.TRUE.equals(this.inProgress.get())) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        HashSet<AuthorityFactory> hashSet = new HashSet<AuthorityFactory>();
        hashSet.add(this);
        try {
            this.inProgress.set(Boolean.TRUE);
            for (String string : this.getAuthorityNames()) {
                string = string.trim();
                char c = this.getSeparator(string);
                StringBuilder stringBuilder = new StringBuilder(string);
                int n = stringBuilder.length();
                if (n != 0 && stringBuilder.charAt(n - 1) != c) {
                    stringBuilder.append(c);
                    n = stringBuilder.length();
                }
                stringBuilder.append("all");
                String string2 = stringBuilder.toString();
                block8: for (int i = 0; i < FACTORY_TYPES.length; ++i) {
                    AuthorityFactory authorityFactory;
                    if (!OBJECT_TYPES[i].isAssignableFrom(clazz)) continue;
                    Class<? extends AuthorityFactory> clazz2 = FACTORY_TYPES[i];
                    try {
                        authorityFactory = this.getAuthorityFactory(clazz2, string2);
                    }
                    catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                        continue;
                    }
                    if (!hashSet.add(authorityFactory)) continue;
                    AuthorityFactory authorityFactory2 = authorityFactory;
                    while (authorityFactory2 instanceof AuthorityFactoryAdapter) {
                        AuthorityFactoryAdapter authorityFactoryAdapter = (AuthorityFactoryAdapter)authorityFactory2;
                        try {
                            authorityFactory2 = authorityFactoryAdapter.getAuthorityFactory(clazz2, string2);
                        }
                        catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                            continue block8;
                        }
                        if (hashSet.add(authorityFactory2)) continue;
                        continue block8;
                    }
                    for (String string3 : authorityFactory.getAuthorityCodes(clazz)) {
                        if ((string3 = string3.trim()).length() < n || Character.isLetterOrDigit(string3.charAt(n - 1)) || !string.equalsIgnoreCase(string3.substring(0, n - 1))) {
                            stringBuilder.setLength(n);
                            stringBuilder.append(string3);
                            string3 = stringBuilder.toString();
                        }
                        linkedHashSet.add(string3);
                    }
                }
            }
        }
        finally {
            this.inProgress.remove();
        }
        return linkedHashSet;
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        HashSet<AuthorityFactory> hashSet = new HashSet<AuthorityFactory>();
        hashSet.add(this);
        FactoryException factoryException = null;
        for (int i = 0; i < FACTORY_TYPES.length; ++i) {
            AuthorityFactory authorityFactory;
            try {
                authorityFactory = this.getAuthorityFactory(FACTORY_TYPES[i], string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                if (factoryException != null) continue;
                factoryException = noSuchAuthorityCodeException;
                continue;
            }
            if (!hashSet.add(authorityFactory)) continue;
            try {
                return authorityFactory.getDescriptionText(string);
            }
            catch (FactoryException factoryException2) {
                if (factoryException != null && !(factoryException.getCause() instanceof FactoryRegistryException)) continue;
                factoryException = factoryException2;
            }
        }
        if (factoryException == null) {
            factoryException = this.noSuchAuthorityCode(IdentifiedObject.class, string);
        }
        throw factoryException;
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        HashSet<AuthorityFactory> hashSet = new HashSet<AuthorityFactory>();
        hashSet.add(this);
        FactoryException factoryException = null;
        for (int i = 0; i < FACTORY_TYPES.length; ++i) {
            AuthorityFactory authorityFactory;
            try {
                authorityFactory = this.getAuthorityFactory(FACTORY_TYPES[i], string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                if (factoryException != null) continue;
                factoryException = noSuchAuthorityCodeException;
                continue;
            }
            if (!hashSet.add(authorityFactory)) continue;
            try {
                return authorityFactory.createObject(string);
            }
            catch (FactoryException factoryException2) {
                if (factoryException != null && !(factoryException.getCause() instanceof FactoryRegistryException)) continue;
                factoryException = factoryException2;
            }
        }
        if (factoryException == null) {
            factoryException = this.noSuchAuthorityCode(IdentifiedObject.class, string);
        }
        throw factoryException;
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new Finder(this, clazz);
    }

    static class Finder
    extends IdentifiedObjectFinder {
        protected Finder(ManyAuthoritiesFactory manyAuthoritiesFactory, Class<? extends IdentifiedObject> clazz) {
            super(manyAuthoritiesFactory, clazz);
        }

        final Collection<AuthorityFactory> getFactories() {
            return ((ManyAuthoritiesFactory)this.getProxy().getAuthorityFactory()).getFactories();
        }

        final IdentifiedObjectFinder next(Iterator<AuthorityFactory> iterator) throws FactoryException {
            while (iterator.hasNext()) {
                IdentifiedObjectFinder identifiedObjectFinder;
                AuthorityFactory authorityFactory = iterator.next();
                if (ManyAuthoritiesFactory.exclude(authorityFactory) || !(authorityFactory instanceof AbstractAuthorityFactory) || (identifiedObjectFinder = ((AbstractAuthorityFactory)authorityFactory).getIdentifiedObjectFinder(this.getProxy().getType())) == null) continue;
                identifiedObjectFinder.setFullScanAllowed(this.isFullScanAllowed());
                return identifiedObjectFinder;
            }
            return null;
        }

        @Override
        public IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
            IdentifiedObject identifiedObject2;
            block2: {
                IdentifiedObjectFinder identifiedObjectFinder;
                identifiedObject2 = this.createFromIdentifiers(identifiedObject);
                if (identifiedObject2 != null) {
                    return identifiedObject2;
                }
                Collection<AuthorityFactory> collection = this.getFactories();
                if (collection == null) break block2;
                Iterator<AuthorityFactory> iterator = collection.iterator();
                while ((identifiedObjectFinder = this.next(iterator)) != null && (identifiedObject2 = identifiedObjectFinder.find(identifiedObject)) == null) {
                }
            }
            return identifiedObject2;
        }

        @Override
        public String findIdentifier(IdentifiedObject identifiedObject) throws FactoryException {
            IdentifiedObject identifiedObject2 = this.createFromIdentifiers(identifiedObject);
            if (identifiedObject2 != null) {
                return identifiedObject2.getName().toString();
            }
            Collection<AuthorityFactory> collection = this.getFactories();
            if (collection != null) {
                IdentifiedObjectFinder identifiedObjectFinder;
                Iterator<AuthorityFactory> iterator = collection.iterator();
                while ((identifiedObjectFinder = this.next(iterator)) != null) {
                    String string = identifiedObjectFinder.findIdentifier(identifiedObject);
                    if (string == null) continue;
                    return string;
                }
            }
            return null;
        }
    }
}

