/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.util.Utilities;
import org.opengis.referencing.datum.PrimeMeridian;

public class DefaultPrimeMeridian
extends AbstractIdentifiedObject
implements PrimeMeridian {
    private static final long serialVersionUID = 541978454643213305L;
    public static final DefaultPrimeMeridian GREENWICH = new DefaultPrimeMeridian("Greenwich", 0.0, NonSI.DEGREE_ANGLE);
    private final double greenwichLongitude;
    private final Unit<Angle> angularUnit;

    public DefaultPrimeMeridian(String string, double d, Unit<Angle> unit) {
        this(Collections.singletonMap("name", string), d, unit);
    }

    public DefaultPrimeMeridian(Map<String, ?> map, double d, Unit<Angle> unit) {
        super(map);
        this.greenwichLongitude = d;
        this.angularUnit = unit;
        DefaultPrimeMeridian.ensureAngularUnit(unit);
    }

    @Override
    public double getGreenwichLongitude() {
        return this.greenwichLongitude;
    }

    public double getGreenwichLongitude(Unit<Angle> unit) {
        return this.getAngularUnit().getConverterTo(unit).convert(this.getGreenwichLongitude());
    }

    @Override
    public Unit<Angle> getAngularUnit() {
        return this.angularUnit;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultPrimeMeridian defaultPrimeMeridian = (DefaultPrimeMeridian)abstractIdentifiedObject;
            if (bl) {
                return Utilities.equals(this.greenwichLongitude, defaultPrimeMeridian.greenwichLongitude) && Utilities.equals(this.angularUnit, defaultPrimeMeridian.angularUnit);
            }
            return Utilities.equals(this.getGreenwichLongitude(NonSI.DEGREE_ANGLE), defaultPrimeMeridian.getGreenwichLongitude(NonSI.DEGREE_ANGLE));
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.greenwichLongitude);
        return (int)(l >>> 32) ^ (int)l ^ 0x70EC83F9;
    }
}

