/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.crs.UnprefixedMap;
import org.geotools.referencing.operation.DefaultConversion;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;

public class AbstractDerivedCRS
extends AbstractSingleCRS
implements GeneralDerivedCRS {
    private static final long serialVersionUID = -175151161496419854L;
    public static final String CONVERSION_TYPE_KEY = "conversionType";
    public static final ThreadLocal<Boolean> _COMPARING = new ThreadLocal();
    protected final CoordinateReferenceSystem baseCRS;
    protected final Conversion conversionFromBase;

    protected AbstractDerivedCRS(Map<String, ?> map, Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        super(map, AbstractDerivedCRS.getDatum(coordinateReferenceSystem), coordinateSystem);
        AbstractDerivedCRS.ensureNonNull("conversionFromBase", conversion);
        AbstractDerivedCRS.ensureNonNull("baseToDerived", mathTransform);
        this.baseCRS = coordinateReferenceSystem;
        AbstractDerivedCRS.checkDimensions(coordinateReferenceSystem, mathTransform, coordinateSystem);
        DefaultOperationMethod.checkDimensions(conversion.getMethod(), mathTransform);
        Class clazz = (Class)map.get(CONVERSION_TYPE_KEY);
        Class<? extends Conversion> clazz2 = this.getConversionType();
        if (clazz != null) {
            clazz2 = clazz.asSubclass(clazz2);
        }
        this.conversionFromBase = DefaultConversion.create(conversion, coordinateReferenceSystem, this, mathTransform, clazz2);
    }

    AbstractDerivedCRS(Map<String, ?> map, OperationMethod operationMethod, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        super(map, AbstractDerivedCRS.getDatum(coordinateReferenceSystem), coordinateSystem);
        AbstractDerivedCRS.ensureNonNull("method", operationMethod);
        AbstractDerivedCRS.ensureNonNull("baseToDerived", mathTransform);
        this.baseCRS = coordinateReferenceSystem;
        AbstractDerivedCRS.checkDimensions(coordinateReferenceSystem, mathTransform, coordinateSystem);
        DefaultOperationMethod.checkDimensions(operationMethod, mathTransform);
        this.conversionFromBase = (Conversion)DefaultOperation.create(new UnprefixedMap(map, "conversion."), coordinateReferenceSystem, this, mathTransform, operationMethod, this instanceof ProjectedCRS ? Projection.class : Conversion.class);
    }

    private static Datum getDatum(CoordinateReferenceSystem coordinateReferenceSystem) {
        AbstractDerivedCRS.ensureNonNull("base", coordinateReferenceSystem);
        return coordinateReferenceSystem instanceof SingleCRS ? ((SingleCRS)coordinateReferenceSystem).getDatum() : null;
    }

    private static void checkDimensions(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        int n3 = n;
        int n4 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        if (n3 != n4 || (n3 = n2) != (n4 = coordinateSystem.getDimension())) {
            throw new MismatchedDimensionException(Errors.format(93, n3, n4));
        }
    }

    @Override
    public CoordinateReferenceSystem getBaseCRS() {
        return this.baseCRS;
    }

    @Override
    public Conversion getConversionFromBase() {
        return this.conversionFromBase;
    }

    Class<? extends Conversion> getConversionType() {
        return Conversion.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            AbstractDerivedCRS abstractDerivedCRS = (AbstractDerivedCRS)abstractIdentifiedObject;
            if (AbstractDerivedCRS.equals(this.baseCRS, abstractDerivedCRS.baseCRS, bl)) {
                Boolean bl2 = _COMPARING.get();
                if (bl2 != null && bl2.booleanValue()) {
                    return true;
                }
                try {
                    _COMPARING.set(Boolean.TRUE);
                    boolean bl3 = AbstractDerivedCRS.equals(this.conversionFromBase, abstractDerivedCRS.conversionFromBase, bl);
                    return bl3;
                }
                finally {
                    _COMPARING.remove();
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x550241F2 ^ this.baseCRS.hashCode() ^ this.conversionFromBase.getName().hashCode();
    }
}

