/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.resources.LazySet;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.Factory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;

public final class ReferencingFactoryFinder
extends FactoryFinder {
    private static FactoryRegistry registry;

    private ReferencingFactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(ReferencingFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(new Class[]{DatumFactory.class, CSFactory.class, CRSFactory.class, DatumAuthorityFactory.class, CSAuthorityFactory.class, CRSAuthorityFactory.class, MathTransformFactory.class, CoordinateOperationFactory.class, CoordinateOperationAuthorityFactory.class});
        }
        return registry;
    }

    private static synchronized <T extends Factory> Set<T> getFactories(Class<T> clazz, Hints hints) {
        hints = ReferencingFactoryFinder.mergeSystemHints(hints);
        return new LazySet<T>(ReferencingFactoryFinder.getServiceRegistry().getServiceProviders(clazz, null, hints));
    }

    private static synchronized <T extends Factory> T getFactory(Class<T> clazz, Hints hints, Hints.Key key) throws FactoryRegistryException {
        hints = ReferencingFactoryFinder.mergeSystemHints(hints);
        return (T)((Factory)ReferencingFactoryFinder.getServiceRegistry().getServiceProvider(clazz, null, hints, key));
    }

    private static synchronized <T extends AuthorityFactory> T getAuthorityFactory(Class<T> clazz, String string, Hints hints, Hints.Key key) throws FactoryRegistryException {
        hints = ReferencingFactoryFinder.mergeSystemHints(hints);
        return (T)((AuthorityFactory)ReferencingFactoryFinder.getServiceRegistry().getServiceProvider(clazz, new AuthorityFilter(string), hints, key));
    }

    public static DatumFactory getDatumFactory(Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getFactory(DatumFactory.class, hints, Hints.DATUM_FACTORY);
    }

    public static Set<DatumFactory> getDatumFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(DatumFactory.class, hints);
    }

    public static CSFactory getCSFactory(Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getFactory(CSFactory.class, hints, Hints.CS_FACTORY);
    }

    public static CRSFactory getCRSFactory(Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getFactory(CRSFactory.class, hints, Hints.CRS_FACTORY);
    }

    public static CoordinateOperationFactory getCoordinateOperationFactory(Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getFactory(CoordinateOperationFactory.class, hints, Hints.COORDINATE_OPERATION_FACTORY);
    }

    public static Set<CoordinateOperationFactory> getCoordinateOperationFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(CoordinateOperationFactory.class, hints);
    }

    public static Set<CRSAuthorityFactory> getCRSAuthorityFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(CRSAuthorityFactory.class, hints);
    }

    public static CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String string, Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getAuthorityFactory(CoordinateOperationAuthorityFactory.class, string, hints, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY);
    }

    public static MathTransformFactory getMathTransformFactory(Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getFactory(MathTransformFactory.class, hints, Hints.MATH_TRANSFORM_FACTORY);
    }

    private static final class AuthorityFilter
    implements ServiceRegistry.Filter {
        private final String authority;

        public AuthorityFilter(String string) {
            this.authority = string;
        }

        @Override
        public boolean filter(Object object) {
            if (this.authority == null) {
                return false;
            }
            return Citations.identifierMatches(((AuthorityFactory)object).getAuthority(), this.authority);
        }
    }
}

