/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.metadata.AbstractMetadata;
import org.geotools.metadata.MetadataStandard;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CheckedArrayList;
import org.geotools.util.CheckedHashSet;
import org.geotools.util.logging.Logging;

public abstract class ModifiableMetadata
extends AbstractMetadata
implements Cloneable {
    private static final ModifiableMetadata FREEZING = new Null();
    private transient ModifiableMetadata unmodifiable;

    protected ModifiableMetadata() {
    }

    protected ModifiableMetadata(Object object) throws ClassCastException, UnmodifiableMetadataException {
        super(object);
    }

    @Override
    public final boolean isModifiable() {
        return this.unmodifiable != this;
    }

    public synchronized AbstractMetadata unmodifiable() {
        if (this.unmodifiable == null) {
            ModifiableMetadata modifiableMetadata;
            try {
                modifiableMetadata = this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Logging.unexpectedException(LOGGER, cloneNotSupportedException);
                return this;
            }
            modifiableMetadata.freeze();
            this.unmodifiable = modifiableMetadata;
        }
        assert (!this.unmodifiable.isModifiable());
        return this.unmodifiable;
    }

    /*
     * WARNING - void declaration
     */
    static Object unmodifiable(Object object) {
        if (object instanceof ModifiableMetadata) {
            return ((ModifiableMetadata)object).unmodifiable();
        }
        if (object instanceof Collection) {
            Collection<Object> collection = (UnmodifiableArrayList<Object>)object;
            if (collection.isEmpty()) {
                collection = collection instanceof List ? Collections.EMPTY_LIST : Collections.EMPTY_SET;
            } else {
                void entry;
                Object[] objectArray = collection.toArray();
                boolean i = false;
                while (entry < objectArray.length) {
                    objectArray[entry] = ModifiableMetadata.unmodifiable(objectArray[entry]);
                    ++entry;
                }
                collection = UnmodifiableArrayList.wrap(objectArray);
                if (collection instanceof Set) {
                    collection = Collections.unmodifiableSet(new LinkedHashSet<Object>(collection));
                }
            }
            return collection;
        }
        if (object instanceof Map) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            if (linkedHashMap.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            linkedHashMap = new LinkedHashMap(linkedHashMap);
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                entry.setValue(ModifiableMetadata.unmodifiable(entry.getValue()));
            }
            return Collections.unmodifiableMap(linkedHashMap);
        }
        if (object instanceof org.opengis.util.Cloneable) {
            return ((org.opengis.util.Cloneable)object).clone();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void freeze() {
        ModifiableMetadata modifiableMetadata = null;
        try {
            this.unmodifiable = FREEZING;
            this.getStandard().freeze(this);
            modifiableMetadata = this;
        }
        finally {
            this.unmodifiable = modifiableMetadata;
        }
    }

    protected void checkWritePermission() throws UnmodifiableMetadataException {
        assert (Thread.holdsLock(this));
        if (!this.isModifiable()) {
            throw new UnmodifiableMetadataException(Errors.format(190));
        }
        this.invalidate();
    }

    @Override
    final void invalidate() {
        super.invalidate();
        this.unmodifiable = null;
    }

    private static boolean isModifiable(Collection collection) {
        if (!collection.isEmpty()) {
            try {
                collection.clear();
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected final <E> Collection<E> copyCollection(Collection<? extends E> collection, Collection<E> collection2, Class<E> clazz) throws UnmodifiableMetadataException {
        if (this.unmodifiable == FREEZING) {
            assert (!ModifiableMetadata.isModifiable(collection));
            Collection<E> collection3 = collection;
            return collection3;
        }
        this.checkWritePermission();
        if (collection != collection2) {
            if (collection == null) {
                if (collection2 != null) {
                    collection2.clear();
                }
            } else {
                boolean bl = collection instanceof List;
                if (collection2 != null && collection2 instanceof List == bl) {
                    collection2.clear();
                } else {
                    int n = collection.size();
                    if (bl) {
                        collection2 = new MutableList<E>(clazz, n);
                    } else {
                        n = Math.round((float)n / 0.75f) + 1;
                        collection2 = new MutableSet<E>(clazz, n);
                    }
                }
                collection2.addAll(collection);
            }
        }
        return collection2;
    }

    protected final <E> Collection<E> nonNullCollection(Collection<E> collection, Class<E> clazz) {
        assert (Thread.holdsLock(this));
        if (collection != null) {
            return collection;
        }
        if (this.isModifiable()) {
            return new MutableSet<E>(clazz);
        }
        return Collections.emptySet();
    }

    protected ModifiableMetadata clone() throws CloneNotSupportedException {
        return (ModifiableMetadata)super.clone();
    }

    private final class MutableList<E>
    extends CheckedArrayList<E> {
        private static final long serialVersionUID = -5016778173550153002L;

        public MutableList(Class<E> clazz) {
            super(clazz);
        }

        public MutableList(Class<E> clazz, int n) {
            super(clazz, n);
        }

        @Override
        protected Object getLock() {
            return ModifiableMetadata.this;
        }

        @Override
        protected void checkWritePermission() throws UnsupportedOperationException {
            ModifiableMetadata.this.checkWritePermission();
        }
    }

    private final class MutableSet<E>
    extends CheckedHashSet<E> {
        private static final long serialVersionUID = 2337350768744454264L;

        public MutableSet(Class<E> clazz) {
            super(clazz);
        }

        public MutableSet(Class<E> clazz, int n) {
            super(clazz, n);
        }

        @Override
        protected Object getLock() {
            return ModifiableMetadata.this;
        }

        @Override
        protected void checkWritePermission() throws UnsupportedOperationException {
            ModifiableMetadata.this.checkWritePermission();
        }
    }

    private static final class Null
    extends ModifiableMetadata {
        private Null() {
        }

        @Override
        public MetadataStandard getStandard() {
            return null;
        }
    }
}

