/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Map;
import org.geotools.feature.type.PropertyDescriptorImpl;
import org.geotools.resources.Classes;
import org.geotools.util.Utilities;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;

public class AttributeDescriptorImpl
extends PropertyDescriptorImpl
implements AttributeDescriptor {
    protected final Object defaultValue;

    public AttributeDescriptorImpl(AttributeType attributeType, Name name, int n, int n2, boolean bl, Object object) {
        super(attributeType, name, n, n2, bl);
        this.defaultValue = object;
    }

    @Override
    public AttributeType getType() {
        return (AttributeType)super.getType();
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AttributeDescriptorImpl)) {
            return false;
        }
        AttributeDescriptorImpl attributeDescriptorImpl = (AttributeDescriptorImpl)object;
        return super.equals(object) && Utilities.deepEquals(this.defaultValue, attributeDescriptorImpl.defaultValue);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(Classes.getShortClassName(this));
        stringBuffer.append(" ");
        stringBuffer.append(this.getName());
        if (this.type != null) {
            stringBuffer.append(" <");
            stringBuffer.append(this.type.getName().getLocalPart());
            stringBuffer.append(":");
            stringBuffer.append(Classes.getShortName(this.type.getBinding()));
            stringBuffer.append(">");
        }
        if (this.isNillable) {
            stringBuffer.append(" nillable");
        }
        if (this.minOccurs != 1 || this.maxOccurs != 1) {
            stringBuffer.append(" ");
            stringBuffer.append(this.minOccurs);
            stringBuffer.append(":");
            stringBuffer.append(this.maxOccurs);
        }
        if (this.defaultValue != null) {
            stringBuffer.append("\ndefault= ");
            stringBuffer.append(this.defaultValue);
        }
        if (this.userData != null && !this.userData.isEmpty()) {
            stringBuffer.append("\nuserData=(");
            for (Map.Entry entry : this.userData.entrySet()) {
                stringBuffer.append("\n\t");
                stringBuffer.append(entry.getKey());
                stringBuffer.append(" ==> ");
                stringBuffer.append(entry.getValue());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getLocalName() {
        return this.getName().getLocalPart();
    }
}

