/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.type.FeatureTypeImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

public class SimpleFeatureTypeImpl
extends FeatureTypeImpl
implements SimpleFeatureType {
    List<AttributeType> types = null;
    Map<String, Integer> index = SimpleFeatureTypeImpl.buildIndex(this);

    public SimpleFeatureTypeImpl(Name name, List<AttributeDescriptor> list, GeometryDescriptor geometryDescriptor, boolean bl, List<Filter> list2, AttributeType attributeType, InternationalString internationalString) {
        super(name, list, geometryDescriptor, bl, list2, attributeType, internationalString);
    }

    @Override
    public final List<AttributeDescriptor> getAttributeDescriptors() {
        return (List)this.getDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttributeType> getTypes() {
        if (this.types == null) {
            SimpleFeatureTypeImpl simpleFeatureTypeImpl = this;
            synchronized (simpleFeatureTypeImpl) {
                if (this.types == null) {
                    this.types = new ArrayList<AttributeType>();
                    for (AttributeDescriptor attributeDescriptor : this.getAttributeDescriptors()) {
                        this.types.add(attributeDescriptor.getType());
                    }
                }
            }
        }
        return this.types;
    }

    @Override
    public AttributeType getType(int n) {
        return this.getTypes().get(n);
    }

    @Override
    public AttributeDescriptor getDescriptor(Name name) {
        return (AttributeDescriptor)super.getDescriptor(name);
    }

    @Override
    public AttributeDescriptor getDescriptor(String string) {
        return (AttributeDescriptor)super.getDescriptor(string);
    }

    @Override
    public AttributeDescriptor getDescriptor(int n) {
        return this.getAttributeDescriptors().get(n);
    }

    @Override
    public int indexOf(String string) {
        Integer n = this.index.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    @Override
    public int getAttributeCount() {
        return this.getAttributeDescriptors().size();
    }

    @Override
    public String getTypeName() {
        return this.getName().getLocalPart();
    }

    static Map<String, Integer> buildIndex(SimpleFeatureType simpleFeatureType) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 0;
        for (AttributeDescriptor attributeDescriptor : simpleFeatureType.getAttributeDescriptors()) {
            hashMap.put(attributeDescriptor.getLocalName(), n++);
        }
        if (simpleFeatureType.getGeometryDescriptor() != null) {
            hashMap.put((String)null, (Integer)hashMap.get(simpleFeatureType.getGeometryDescriptor().getLocalName()));
        }
        return hashMap;
    }
}

