/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.rmi.server.UID;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.feature.type.Types;
import org.geotools.util.Converters;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class SimpleFeatureBuilder {
    SimpleFeatureType featureType;
    FeatureFactory factory;
    Map<String, Integer> index;
    Object[] values;
    int next;
    Map<Object, Object>[] userData;
    Map<Object, Object> featureUserData;
    boolean validating;

    public SimpleFeatureBuilder(SimpleFeatureType simpleFeatureType) {
        this(simpleFeatureType, CommonFactoryFinder.getFeatureFactory(null));
    }

    public SimpleFeatureBuilder(SimpleFeatureType simpleFeatureType, FeatureFactory featureFactory) {
        this.featureType = simpleFeatureType;
        this.factory = featureFactory;
        this.index = simpleFeatureType instanceof SimpleFeatureTypeImpl ? ((SimpleFeatureTypeImpl)simpleFeatureType).index : SimpleFeatureTypeImpl.buildIndex(simpleFeatureType);
        this.reset();
    }

    public void reset() {
        this.values = new Object[this.featureType.getAttributeCount()];
        this.next = 0;
        this.userData = null;
        this.featureUserData = null;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void init(SimpleFeature simpleFeature) {
        this.reset();
        if (simpleFeature instanceof SimpleFeatureImpl) {
            SimpleFeatureImpl simpleFeatureImpl = (SimpleFeatureImpl)simpleFeature;
            System.arraycopy(simpleFeatureImpl.values, 0, this.values, 0, simpleFeatureImpl.values.length);
        } else {
            for (Object object : simpleFeature.getAttributes()) {
                this.add(object);
            }
        }
    }

    public void add(Object object) {
        this.set(this.next, object);
        ++this.next;
    }

    public void addAll(List<Object> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.get(i));
        }
    }

    public void addAll(Object[] objectArray) {
        this.addAll(Arrays.asList(objectArray));
    }

    public void set(Name name, Object object) {
        this.set(name.getLocalPart(), object);
    }

    public void set(String string, Object object) {
        int n = this.featureType.indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("No such attribute:" + string);
        }
        this.set(n, object);
    }

    public void set(int n, Object object) {
        if (n >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("Can handle " + this.values.length + " attributes only, index is " + n);
        }
        AttributeDescriptor attributeDescriptor = this.featureType.getDescriptor(n);
        this.values[n] = this.convert(object, attributeDescriptor);
        if (this.validating) {
            Types.validate(attributeDescriptor, this.values[n]);
        }
    }

    private Object convert(Object object, AttributeDescriptor attributeDescriptor) {
        if (object != null) {
            Class<?> clazz = attributeDescriptor.getType().getBinding();
            Object obj = Converters.convert(object, clazz);
            if (obj != null) {
                object = obj;
            }
        } else if (!attributeDescriptor.isNillable() && (object = attributeDescriptor.getDefaultValue()) == null) {
            object = DataUtilities.defaultValue(attributeDescriptor.getType().getBinding());
        }
        return object;
    }

    public SimpleFeature buildFeature(String string) {
        if (string == null) {
            string = SimpleFeatureBuilder.createDefaultFeatureId();
        }
        Object[] objectArray = this.values;
        Map<Object, Object>[] mapArray = this.userData;
        Map<Object, Object> map = this.featureUserData;
        this.reset();
        SimpleFeature simpleFeature = this.factory.createSimpleFeature(objectArray, this.featureType, string);
        if (mapArray != null) {
            for (int i = 0; i < mapArray.length; ++i) {
                if (mapArray[i] == null) continue;
                simpleFeature.getProperty(this.featureType.getDescriptor(i).getName()).getUserData().putAll(mapArray[i]);
            }
        }
        if (map != null) {
            simpleFeature.getUserData().putAll(map);
        }
        return simpleFeature;
    }

    public static String createDefaultFeatureId() {
        return "fid-" + new UID().toString().replace(':', '_');
    }

    public static SimpleFeature build(SimpleFeatureType simpleFeatureType, Object[] objectArray, String string) {
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(simpleFeatureType);
        simpleFeatureBuilder.addAll(objectArray);
        return simpleFeatureBuilder.buildFeature(string);
    }

    public static SimpleFeature build(SimpleFeatureType simpleFeatureType, List<Object> list, String string) {
        return SimpleFeatureBuilder.build(simpleFeatureType, list.toArray(), string);
    }

    public static SimpleFeature copy(SimpleFeature simpleFeature) {
        if (simpleFeature == null) {
            return null;
        }
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(simpleFeature.getFeatureType());
        simpleFeatureBuilder.init(simpleFeature);
        return simpleFeatureBuilder.buildFeature(simpleFeature.getID());
    }
}

