/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.Iterator;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.collection.FilteredIterator;
import org.geotools.feature.collection.SubFeatureList;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public class SubFeatureCollection
extends AbstractFeatureCollection {
    protected Filter filter;
    protected SimpleFeatureCollection collection;
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public SubFeatureCollection(SimpleFeatureCollection simpleFeatureCollection, Filter filter) {
        super((SimpleFeatureType)simpleFeatureCollection.getSchema());
        if (filter == null) {
            filter = Filter.INCLUDE;
        }
        if (filter.equals(Filter.EXCLUDE)) {
            throw new IllegalArgumentException("A subcollection with Filter.EXCLUDE would be empty");
        }
        if (simpleFeatureCollection instanceof SubFeatureCollection) {
            SubFeatureCollection subFeatureCollection = (SubFeatureCollection)simpleFeatureCollection;
            if (filter.equals(Filter.INCLUDE)) {
                this.collection = subFeatureCollection.collection;
                this.filter = subFeatureCollection.filter();
            } else {
                this.collection = subFeatureCollection.collection;
                this.filter = this.ff.and(subFeatureCollection.filter(), filter);
            }
        } else {
            this.collection = simpleFeatureCollection;
            this.filter = filter;
        }
    }

    public Iterator openIterator() {
        return new FilteredIterator<SimpleFeature>(this.collection, this.filter());
    }

    public void closeIterator(Iterator iterator) {
        if (iterator == null) {
            return;
        }
        if (iterator instanceof FilteredIterator) {
            FilteredIterator filteredIterator = (FilteredIterator)iterator;
            filteredIterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int n = 0;
        Iterator<SimpleFeature> iterator = null;
        try {
            iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
        }
        finally {
            this.close(iterator);
        }
        return n;
    }

    protected Filter filter() {
        if (this.filter == null) {
            this.filter = this.createFilter();
        }
        return this.filter;
    }

    protected Filter createFilter() {
        return Filter.INCLUDE;
    }

    @Override
    public SimpleFeatureIterator features() {
        return new DelegateSimpleFeatureIterator(this, this.iterator());
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter.equals(Filter.INCLUDE)) {
            return this;
        }
        if (filter.equals(Filter.EXCLUDE)) {
            // empty if block
        }
        return new SubFeatureCollection(this, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            boolean bl = !iterator.hasNext();
            return bl;
        }
        finally {
            this.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accepts(FeatureVisitor featureVisitor, ProgressListener progressListener) {
        Iterator<SimpleFeature> iterator = null;
        try {
            float f = this.size();
            float f2 = 0.0f;
            progressListener.started();
            iterator = this.iterator();
            while (!progressListener.isCanceled() && iterator.hasNext()) {
                try {
                    SimpleFeature simpleFeature = iterator.next();
                    featureVisitor.visit(simpleFeature);
                }
                catch (Exception exception) {
                    progressListener.exceptionOccurred(exception);
                }
                float f3 = f2;
                f2 = f3 + 1.0f;
                progressListener.progress(f3 / f);
            }
        }
        finally {
            progressListener.complete();
            this.close(iterator);
        }
    }

    @Override
    public SimpleFeatureCollection sort(SortBy sortBy) {
        return new SubFeatureList(this.collection, this.filter, sortBy);
    }

    @Override
    public boolean add(SimpleFeature simpleFeature) {
        return this.collection.add(simpleFeature);
    }

    @Override
    public void clear() {
        List<SimpleFeature> list = DataUtilities.list(this);
        this.removeAll(list);
    }

    @Override
    public boolean remove(Object object) {
        return this.collection.remove(object);
    }

    @Override
    public String getID() {
        return this.collection.getID();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        BoundsVisitor boundsVisitor = new BoundsVisitor();
        this.accepts(boundsVisitor, new NullProgressListener());
        return boundsVisitor.getBounds();
    }
}

