/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.MaxFeaturesIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class MaxSimpleFeatureCollection
extends DecoratingSimpleFeatureCollection {
    SimpleFeatureCollection delegate;
    long start;
    long max;

    public MaxSimpleFeatureCollection(SimpleFeatureCollection simpleFeatureCollection, long l, long l2) {
        super(simpleFeatureCollection);
        this.delegate = simpleFeatureCollection;
        this.start = l;
        this.max = l2;
    }

    @Override
    public SimpleFeatureIterator features() {
        return new DelegateSimpleFeatureIterator(this, this.iterator());
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        return new MaxFeaturesIterator<SimpleFeature>(this.delegate.iterator(), this.start, this.max);
    }

    @Override
    public void close(Iterator<SimpleFeature> iterator) {
        Iterator iterator2 = ((MaxFeaturesIterator)iterator).getDelegate();
        this.delegate.close(iterator2);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int n = this.delegate.size();
        if ((long)n < this.start) {
            return 0;
        }
        return (int)Math.min((long)n - this.start, this.max);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty() || this.max == 0L;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray(Object[] objectArray) {
        ArrayList<SimpleFeature> arrayList = new ArrayList<SimpleFeature>();
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            Object[] objectArray2 = arrayList.toArray(objectArray);
            return objectArray2;
        }
        finally {
            this.close(iterator);
        }
    }

    @Override
    public boolean add(SimpleFeature simpleFeature) {
        long l = this.delegate.size();
        if (l < this.max) {
            return this.delegate.add(simpleFeature);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.add((SimpleFeature)iterator.next());
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference(DataUtilities.bounds(this));
    }
}

