/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureWriterIterator;
import org.geotools.data.store.NoContentIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureReaderIterator;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.util.ProgressListener;

public abstract class DataFeatureCollection
implements SimpleFeatureCollection {
    static Logger LOGGER = Logging.getLogger("org.geotools.data");
    private static int unique = 0;
    private final Set open = new HashSet();
    protected String id;
    protected SimpleFeatureType schema;

    protected DataFeatureCollection() {
        this("features" + unique++);
    }

    protected DataFeatureCollection(String string) {
        this(string, null);
    }

    protected DataFeatureCollection(String string, SimpleFeatureType simpleFeatureType) {
        this.id = string == null ? "featureCollection" : string;
        this.schema = simpleFeatureType;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(), this.features());
    }

    @Override
    public abstract ReferencedEnvelope getBounds();

    public abstract int getCount() throws IOException;

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> writer() throws IOException {
        return null;
    }

    @Override
    public SimpleFeatureIterator features() {
        DelegateSimpleFeatureIterator delegateSimpleFeatureIterator = new DelegateSimpleFeatureIterator(this, this.iterator());
        this.open.add(delegateSimpleFeatureIterator);
        return delegateSimpleFeatureIterator;
    }

    @Override
    public final Iterator<SimpleFeature> iterator() {
        Iterator<SimpleFeature> iterator;
        try {
            iterator = this.openIterator();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.open.add(iterator);
        return iterator;
    }

    protected Iterator<SimpleFeature> openIterator() throws IOException {
        try {
            FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter = this.writer();
            if (featureWriter != null) {
                return new FeatureWriterIterator(this.writer());
            }
        }
        catch (IOException iOException) {
            return new NoContentIterator(iOException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            return new FeatureReaderIterator<SimpleFeature>(this.reader());
        }
        catch (IOException iOException) {
            return new NoContentIterator(iOException);
        }
    }

    @Override
    public final void close(Iterator<SimpleFeature> iterator) {
        try {
            this.closeIterator(iterator);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Error closing iterator", iOException);
        }
        this.open.remove(iterator);
    }

    protected void closeIterator(Iterator<SimpleFeature> iterator) throws IOException {
        if (iterator != null) {
            if (iterator instanceof FeatureReaderIterator) {
                FeatureReaderIterator featureReaderIterator = (FeatureReaderIterator)iterator;
                featureReaderIterator.close();
            } else if (iterator instanceof FeatureWriterIterator) {
                FeatureWriterIterator featureWriterIterator = (FeatureWriterIterator)iterator;
                featureWriterIterator.close();
            }
        }
    }

    @Override
    public void close(FeatureIterator<SimpleFeature> featureIterator) {
        featureIterator.close();
        this.open.remove(featureIterator);
    }

    @Override
    public int size() {
        try {
            return this.getCount();
        }
        catch (IOException iOException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "IOException while calculating size() of FeatureCollection", iOException);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Iterator iterator = this.open.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                if (e instanceof Iterator) {
                    this.closeIterator((Iterator)e);
                }
                if (!(e instanceof FeatureIterator)) continue;
                ((SimpleFeatureIterator)e).close();
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isEmpty() {
        FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = null;
        try {
            featureReader = this.reader();
            try {
                boolean bl = !featureReader.hasNext();
                return bl;
            }
            catch (IOException iOException) {
                boolean bl;
                block17: {
                    bl = true;
                    if (featureReader == null) break block17;
                    try {
                        featureReader.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                return bl;
                catch (IOException iOException3) {
                    boolean bl2 = true;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (featureReader != null) {
                try {
                    featureReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean contains(Object var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new SimpleFeature[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray(Object[] objectArray) {
        ArrayList<SimpleFeature> arrayList = new ArrayList<SimpleFeature>();
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        finally {
            this.close(iterator);
        }
        return arrayList.toArray(objectArray);
    }

    @Override
    public boolean add(SimpleFeature simpleFeature) {
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection collection) {
        if (collection instanceof FeatureCollection) {
            return this.addAll((FeatureCollection)((Object)collection));
        }
        try {
            FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter = this.writer();
            if (featureWriter == null) {
                return false;
            }
            try {
                while (featureWriter.hasNext()) {
                    featureWriter.next();
                }
                for (Object e : collection) {
                    if (!(e instanceof SimpleFeature)) continue;
                    SimpleFeature simpleFeature = (SimpleFeature)e;
                    SimpleFeature simpleFeature2 = featureWriter.next();
                    simpleFeature2.setAttributes(simpleFeature.getAttributes());
                    featureWriter.write();
                }
            }
            finally {
                featureWriter.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean addAll(FeatureCollection featureCollection) {
        return false;
    }

    @Override
    public boolean removeAll(Collection collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection collection) {
        return false;
    }

    @Override
    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accepts(FeatureVisitor featureVisitor, ProgressListener progressListener) {
        Iterator<SimpleFeature> iterator = null;
        if (progressListener == null) {
            progressListener = new NullProgressListener();
        }
        try {
            float f = this.size();
            float f2 = 0.0f;
            progressListener.started();
            iterator = this.iterator();
            while (!progressListener.isCanceled() && iterator.hasNext()) {
                try {
                    SimpleFeature simpleFeature = iterator.next();
                    featureVisitor.visit(simpleFeature);
                }
                catch (Exception exception) {
                    progressListener.exceptionOccurred(exception);
                }
                float f3 = f2;
                f2 = f3 + 1.0f;
                progressListener.progress(100.0f * f3 / f);
            }
        }
        finally {
            progressListener.complete();
            this.close(iterator);
        }
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }
}

