/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.File;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.FileChannelDecorator;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.MemoryMapCache;
import org.geotools.data.shapefile.ReadableByteChannelDecorator;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFilesLocker;

public class ShpFiles {
    protected final Map<ShpFileType, URL> urls = new ConcurrentHashMap<ShpFileType, URL>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<Thread, Collection<ShpFilesLocker>> lockers = new ConcurrentHashMap<Thread, Collection<ShpFilesLocker>>();
    private final MemoryMapCache mapCache = new MemoryMapCache();
    private boolean memoryMapCacheEnabled;

    public ShpFiles(URL uRL) throws IllegalArgumentException {
        this.init(uRL);
    }

    private void init(URL uRL) {
        String string = this.baseName(uRL);
        if (string == null) {
            throw new IllegalArgumentException(uRL.getPath() + " is not one of the files types that is known to be associated with a shapefile");
        }
        String string2 = uRL.toExternalForm();
        char c = string2.charAt(string2.length() - 1);
        boolean bl = Character.isUpperCase(c);
        for (ShpFileType object : ShpFileType.values()) {
            URL uRL2;
            String string3 = object.extensionWithPeriod;
            string3 = bl ? string3.toUpperCase() : string3.toLowerCase();
            String string4 = string + string3;
            try {
                uRL2 = new URL(uRL, string4);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
            this.urls.put(object, uRL2);
        }
        if (this.isLocal()) {
            Set<Map.Entry<ShpFileType, URL>> set = this.urls.entrySet();
            HashMap hashMap = new HashMap();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (this.exists((ShpFileType)((Object)entry.getKey())) || (uRL = this.findExistingFile((ShpFileType)((Object)entry.getKey()), (URL)entry.getValue())) == null) continue;
                hashMap.put(entry.getKey(), uRL);
            }
            this.urls.putAll(hashMap);
        }
    }

    private URL findExistingFile(ShpFileType shpFileType, URL uRL) {
        final File file = DataUtilities.urlToFile(uRL);
        File file2 = file.getParentFile();
        if (file2 == null || !file2.exists()) {
            return null;
        }
        File[] fileArray = file2.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file2, String string) {
                return file.getName().equalsIgnoreCase(string);
            }
        });
        if (fileArray.length > 0) {
            try {
                return fileArray[0].toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                ShapefileDataStoreFactory.LOGGER.log(Level.SEVERE, "", malformedURLException);
            }
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void dispose() {
        if (this.numberOfLocks() != 0) {
            this.logCurrentLockers(Level.SEVERE);
            this.lockers.clear();
        }
        this.mapCache.clean();
    }

    public void logCurrentLockers(Level level) {
        for (Collection<ShpFilesLocker> collection : this.lockers.values()) {
            for (ShpFilesLocker shpFilesLocker : collection) {
                StringBuilder stringBuilder = new StringBuilder("The following locker still has a lock: ");
                stringBuilder.append(shpFilesLocker);
                ShapefileDataStoreFactory.LOGGER.log(level, stringBuilder.toString());
            }
        }
    }

    protected String baseName(Object object) {
        for (ShpFileType shpFileType : ShpFileType.values()) {
            Serializable serializable;
            String string = null;
            if (object instanceof File) {
                serializable = (File)object;
                string = shpFileType.toBase((File)serializable);
            }
            if (object instanceof URL) {
                serializable = (URL)object;
                string = shpFileType.toBase((URL)serializable);
            }
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public String get(ShpFileType shpFileType) {
        return this.urls.get((Object)shpFileType).toExternalForm();
    }

    public int numberOfLocks() {
        int n = 0;
        for (Collection<ShpFilesLocker> collection : this.lockers.values()) {
            n += collection.size();
        }
        return n;
    }

    public URL acquireRead(ShpFileType shpFileType, FileReader fileReader) {
        URL uRL = this.urls.get((Object)shpFileType);
        if (uRL == null) {
            return null;
        }
        this.readWriteLock.readLock().lock();
        Collection<ShpFilesLocker> collection = this.getCurrentThreadLockers();
        collection.add(new ShpFilesLocker(uRL, fileReader));
        return uRL;
    }

    public void unlockRead(URL uRL, FileReader fileReader) {
        if (uRL == null) {
            throw new NullPointerException("url cannot be null");
        }
        if (fileReader == null) {
            throw new NullPointerException("requestor cannot be null");
        }
        Collection<ShpFilesLocker> collection = this.getCurrentThreadLockers();
        boolean bl = collection.remove(new ShpFilesLocker(uRL, fileReader));
        if (!bl) {
            throw new IllegalArgumentException("Expected requestor " + fileReader + " to have locked the url but it does not hold the lock for the URL");
        }
        if (collection.size() == 0) {
            this.lockers.remove(Thread.currentThread());
        }
        this.readWriteLock.readLock().unlock();
    }

    public void unlockWrite(URL uRL, FileWriter fileWriter) {
        if (uRL == null) {
            throw new NullPointerException("url cannot be null");
        }
        if (fileWriter == null) {
            throw new NullPointerException("requestor cannot be null");
        }
        Collection<ShpFilesLocker> collection = this.getCurrentThreadLockers();
        boolean bl = collection.remove(new ShpFilesLocker(uRL, fileWriter));
        if (!bl) {
            throw new IllegalArgumentException("Expected requestor " + fileWriter + " to have locked the url but it does not hold the lock for the URL");
        }
        if (collection.size() == 0) {
            this.lockers.remove(Thread.currentThread());
        } else {
            this.regainReadLocks(collection);
        }
        this.readWriteLock.writeLock().unlock();
    }

    private Collection<ShpFilesLocker> getCurrentThreadLockers() {
        Collection<ShpFilesLocker> collection = this.lockers.get(Thread.currentThread());
        if (collection == null) {
            collection = new ArrayList<ShpFilesLocker>();
            this.lockers.put(Thread.currentThread(), collection);
        }
        return collection;
    }

    private void regainReadLocks(Collection<ShpFilesLocker> collection) {
        for (ShpFilesLocker shpFilesLocker : collection) {
            if (shpFilesLocker.reader == null || !shpFilesLocker.upgraded) continue;
            this.readWriteLock.readLock().lock();
            shpFilesLocker.upgraded = false;
        }
    }

    public boolean isLocal() {
        return this.urls.get((Object)ShpFileType.SHP).toExternalForm().toLowerCase().startsWith("file:");
    }

    public InputStream getInputStream(ShpFileType shpFileType, final FileReader fileReader) throws IOException {
        final URL uRL = this.acquireRead(shpFileType, fileReader);
        try {
            FilterInputStream filterInputStream = new FilterInputStream(uRL.openStream()){
                private volatile boolean closed;
                {
                    super(inputStream);
                    this.closed = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        if (!this.closed) {
                            this.closed = true;
                            ShpFiles.this.unlockRead(uRL, fileReader);
                        }
                    }
                }
            };
            return filterInputStream;
        }
        catch (Throwable throwable) {
            this.unlockRead(uRL, fileReader);
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public ReadableByteChannel getReadChannel(ShpFileType shpFileType, FileReader fileReader) throws IOException {
        URL uRL = this.acquireRead(shpFileType, fileReader);
        ReadableByteChannel readableByteChannel = null;
        try {
            if (this.isLocal()) {
                File file = DataUtilities.urlToFile(uRL);
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                readableByteChannel = new FileChannelDecorator(randomAccessFile.getChannel(), this, uRL, fileReader);
            } else {
                InputStream inputStream = uRL.openConnection().getInputStream();
                readableByteChannel = new ReadableByteChannelDecorator(Channels.newChannel(inputStream), this, uRL, fileReader);
            }
        }
        catch (Throwable throwable) {
            this.unlockRead(uRL, fileReader);
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
        return readableByteChannel;
    }

    public String getTypeName() {
        int n;
        String string = ShpFileType.SHP.toBase(this.urls.get((Object)ShpFileType.SHP));
        int n2 = string.indexOf(46, n = Math.max(0, string.lastIndexOf(47) + 1));
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    MappedByteBuffer map(FileChannel fileChannel, URL uRL, FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        if (this.memoryMapCacheEnabled) {
            return this.mapCache.map(fileChannel, uRL, mapMode, l, l2);
        }
        return fileChannel.map(mapMode, l, l2);
    }

    public void setMemoryMapCacheEnabled(boolean bl) {
        this.memoryMapCacheEnabled = bl;
        if (!bl) {
            this.mapCache.clean();
        }
    }

    public boolean exists(ShpFileType shpFileType) throws IllegalArgumentException {
        if (!this.isLocal()) {
            throw new IllegalArgumentException("This method only makes sense if the files are local");
        }
        URL uRL = this.urls.get((Object)shpFileType);
        if (uRL == null) {
            return false;
        }
        File file = DataUtilities.urlToFile(uRL);
        return file.exists();
    }
}

