/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

public class DelegateFeatureReader<T extends FeatureType, F extends Feature>
implements FeatureReader<T, F> {
    FeatureIterator<F> delegate;
    T schema;

    public DelegateFeatureReader(T t, FeatureIterator<F> featureIterator) {
        this.schema = t;
        this.delegate = featureIterator;
    }

    @Override
    public T getFeatureType() {
        return this.schema;
    }

    @Override
    public F next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.delegate == null) {
            throw new IOException("Feature Reader has been closed");
        }
        try {
            F f = this.delegate.next();
            return f;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DataSourceException("There are no more Features", noSuchElementException);
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.delegate != null && this.delegate.hasNext();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.delegate = null;
        this.schema = null;
    }
}

