/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.runtime.windows;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import uk.co.caprica.vlcj.log.Logger;
import uk.co.caprica.vlcj.runtime.windows.internal.LowLevelMouseProc;
import uk.co.caprica.vlcj.runtime.windows.internal.MSLLHOOKSTRUCT;

public class WindowsMouseHook
implements LowLevelMouseProc {
    private static User32 USER32_INSTANCE = User32.INSTANCE;
    private final EventListenerList listenerList = new EventListenerList();
    private final Component relativeTo;
    private Thread hookThread;
    private volatile WinUser.HHOOK hHook;
    private volatile boolean mouseEntered;

    public WindowsMouseHook(Component relativeTo) {
        Logger.debug("WindowsMouseHook(relativeTo={})", relativeTo);
        if (!Platform.isWindows()) {
            throw new IllegalStateException("Windows only");
        }
        this.relativeTo = relativeTo;
    }

    public void addMouseListener(MouseListener listener) {
        Logger.debug("addMouseListener(listener={})", listener);
        this.listenerList.add(MouseListener.class, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        Logger.debug("removeMouseListener(listener={})", listener);
        this.listenerList.remove(MouseListener.class, listener);
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        Logger.debug("addMouseMotionListener(listener={})", listener);
        this.listenerList.add(MouseMotionListener.class, listener);
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        Logger.debug("removeMouseMotionListener(listener={})", listener);
        this.listenerList.remove(MouseMotionListener.class, listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        Logger.debug("addMouseWheelListener(listener={})", listener);
        this.listenerList.add(MouseWheelListener.class, listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        Logger.debug("removeMouseWheelListener(listener={})", listener);
        this.listenerList.remove(MouseWheelListener.class, listener);
    }

    public void start() {
        Logger.debug("start()", new Object[0]);
        if (this.hookThread != null) {
            throw new IllegalStateException("Mouse hook already installed");
        }
        this.hookThread = new MouseHookThread();
        this.hookThread.start();
    }

    public synchronized void release() {
        Logger.debug("release()", new Object[0]);
        WinUser.HHOOK hook = this.getHook();
        if (hook != null) {
            USER32_INSTANCE.UnhookWindowsHookEx(this.hHook);
            hook = null;
        }
        Logger.debug("released", new Object[0]);
    }

    private synchronized WinUser.HHOOK getHook() {
        return this.hHook;
    }

    public WinDef.LRESULT callback(int nCode, WinDef.WPARAM wParam, MSLLHOOKSTRUCT lParam) {
        Logger.trace("callback(nCode={},wParam={},lParam={})", nCode, wParam, lParam);
        if (nCode >= 0) {
            Window window = SwingUtilities.getWindowAncestor(this.relativeTo);
            Logger.trace("window={}", window);
            if (window != null && window.isActive()) {
                Logger.trace("window is active", new Object[0]);
                if (this.relativeTo.isShowing() && this.relativeTo.isValid()) {
                    Logger.trace("window is visible", new Object[0]);
                    int absX = lParam.pt.x;
                    int absY = lParam.pt.y;
                    Point componentPoint = this.relativeTo.getLocationOnScreen();
                    int relX = componentPoint.x;
                    int relY = componentPoint.y;
                    int relW = relX + this.relativeTo.getWidth();
                    int relH = relY + this.relativeTo.getHeight();
                    if (absX >= relX && absY >= relY && absX < relW && absY < relH) {
                        Logger.trace("event inside component bounds", new Object[0]);
                        if (!this.mouseEntered) {
                            this.mouseEntered = true;
                            this.fireMouseEvent(504, 0, lParam);
                        }
                        switch (wParam.intValue()) {
                            case 512: {
                                this.fireMouseMotionEvent(503, 0, lParam);
                                break;
                            }
                            case 513: {
                                this.fireMouseEvent(501, 1, lParam);
                                break;
                            }
                            case 514: {
                                this.fireMouseEvent(502, 1, lParam);
                                break;
                            }
                            case 516: {
                                this.fireMouseEvent(501, 2, lParam);
                                break;
                            }
                            case 517: {
                                this.fireMouseEvent(502, 2, lParam);
                                break;
                            }
                            case 519: {
                                this.fireMouseEvent(501, 3, lParam);
                                break;
                            }
                            case 520: {
                                this.fireMouseEvent(502, 3, lParam);
                                break;
                            }
                            case 522: {
                                this.fireMouseWheelEvent(507, lParam);
                                break;
                            }
                        }
                    } else {
                        Logger.trace("event outside component bounds", new Object[0]);
                        if (this.mouseEntered) {
                            this.mouseEntered = false;
                            this.fireMouseEvent(505, 0, lParam);
                        }
                    }
                }
            }
        }
        return USER32_INSTANCE.CallNextHookEx(this.hHook, nCode, wParam, lParam.getPointer());
    }

    private void fireMouseMotionEvent(int eventType, int button, MSLLHOOKSTRUCT lParam) {
        Logger.trace("fireMouseMotionEvent(eventType={},button={},lParam={})", eventType, button, lParam);
        MouseMotionListener[] listeners = (MouseMotionListener[])this.listenerList.getListeners(MouseMotionListener.class);
        if (listeners.length > 0) {
            MouseEvent evt = this.createMouseEvent(eventType, button, lParam);
            for (int i = listeners.length - 1; i >= 0; --i) {
                switch (eventType) {
                    case 503: {
                        listeners[i].mouseMoved(evt);
                    }
                }
            }
        }
    }

    private void fireMouseEvent(int eventType, int button, MSLLHOOKSTRUCT lParam) {
        Logger.trace("fireMouseEvent(eventType={},button={},lParam={})", eventType, button, lParam);
        MouseListener[] listeners = (MouseListener[])this.listenerList.getListeners(MouseListener.class);
        if (listeners.length > 0) {
            MouseEvent evt = this.createMouseEvent(eventType, button, lParam);
            block6: for (int i = listeners.length - 1; i >= 0; --i) {
                switch (eventType) {
                    case 501: {
                        listeners[i].mousePressed(evt);
                        continue block6;
                    }
                    case 502: {
                        listeners[i].mouseReleased(evt);
                        continue block6;
                    }
                    case 504: {
                        listeners[i].mouseEntered(evt);
                        continue block6;
                    }
                    case 505: {
                        listeners[i].mouseExited(evt);
                    }
                }
            }
        }
    }

    private void fireMouseWheelEvent(int eventType, MSLLHOOKSTRUCT lParam) {
        Logger.trace("fireMouseWheelEvent(eventType={},lParam={})", eventType, lParam);
        MouseWheelListener[] listeners = (MouseWheelListener[])this.listenerList.getListeners(MouseWheelListener.class);
        if (listeners.length > 0) {
            MouseWheelEvent evt = this.createMouseWheelEvent(eventType, lParam);
            for (int i = listeners.length - 1; i >= 0; --i) {
                switch (eventType) {
                    case 507: {
                        listeners[i].mouseWheelMoved(evt);
                    }
                }
            }
        }
    }

    private MouseEvent createMouseEvent(int eventType, int button, MSLLHOOKSTRUCT lParam) {
        WinUser.POINT pt = lParam.pt;
        Point rl = this.relativeTo.getLocationOnScreen();
        int x = pt.x - rl.x;
        int y = pt.y - rl.y;
        return new MouseEvent(this.relativeTo, eventType, lParam.time.longValue(), 0, x, y, 0, false, button);
    }

    private MouseWheelEvent createMouseWheelEvent(int eventType, MSLLHOOKSTRUCT lParam) {
        WinUser.POINT pt = lParam.pt;
        Point rl = this.relativeTo.getLocationOnScreen();
        int x = pt.x - rl.x;
        int y = pt.y - rl.y;
        int wheelRotation = lParam.mouseData.intValue() >> 16;
        return new MouseWheelEvent(this.relativeTo, eventType, lParam.time.longValue(), 0, x, y, 0, false, 0, 1, wheelRotation * -1);
    }

    private class MouseHookThread
    extends Thread {
        private MouseHookThread() {
        }

        public void run() {
            Logger.debug("run()", new Object[0]);
            try {
                WindowsMouseHook.this.hHook = USER32_INSTANCE.SetWindowsHookEx(14, WindowsMouseHook.this, (WinDef.HINSTANCE)Kernel32.INSTANCE.GetModuleHandle(null), 0);
                WinUser.MSG msg = new WinUser.MSG();
                while (USER32_INSTANCE.GetMessage(msg, null, 0, 0) != 0) {
                    USER32_INSTANCE.TranslateMessage(msg);
                    USER32_INSTANCE.DispatchMessage(msg);
                    if (WindowsMouseHook.this.getHook() != null) continue;
                    break;
                }
            }
            catch (Exception e) {
                Logger.error("Mouse hook failure", e, new Object[0]);
            }
            Logger.debug("mouse hook runnable exits", new Object[0]);
        }
    }
}

