/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.list;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.LibVlcFactory;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_playback_mode_e;
import uk.co.caprica.vlcj.log.Logger;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.list.MediaList;
import uk.co.caprica.vlcj.player.list.MediaListPlayerEventListener;
import uk.co.caprica.vlcj.player.list.MediaListPlayerMode;

public class MediaListPlayer {
    private final LibVlc libvlc = LibVlcFactory.factory().synchronise().log().create();
    private final List<MediaListPlayerEventListener> eventListenerList = new ArrayList<MediaListPlayerEventListener>();
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private libvlc_instance_t instance;
    private libvlc_media_list_player_t mediaListPlayerInstance;
    private libvlc_event_manager_t mediaListPlayerEventManager;
    private libvlc_callback_t callback;
    private AtomicBoolean released = new AtomicBoolean();

    public MediaListPlayer(libvlc_instance_t instance) {
        this.instance = instance;
        this.createInstance();
    }

    public void addMediaListPlayerEventListener(MediaListPlayerEventListener listener) {
        Logger.debug("addMediaPlayerEventListener(listener={})", listener);
        this.eventListenerList.add(listener);
    }

    public void removeMediaListPlayerEventListener(MediaListPlayerEventListener listener) {
        Logger.debug("removeMediaPlayerEventListener(listener={})", listener);
        this.eventListenerList.remove(listener);
    }

    public void setMediaPlayer(MediaPlayer mediaPlayer) {
        Logger.debug("setMediaPlayer(mediaPlayer={})", mediaPlayer);
        this.libvlc.libvlc_media_list_player_set_media_player(this.mediaListPlayerInstance, mediaPlayer.mediaPlayerInstance());
    }

    public void setMediaList(MediaList mediaList) {
        Logger.debug("setMediaList(mediaList={})", mediaList);
        this.libvlc.libvlc_media_list_player_set_media_list(this.mediaListPlayerInstance, mediaList.mediaListInstance());
    }

    public void play() {
        Logger.debug("play()", new Object[0]);
        this.libvlc.libvlc_media_list_player_play(this.mediaListPlayerInstance);
    }

    public void pause() {
        Logger.debug("pause()", new Object[0]);
        this.libvlc.libvlc_media_list_player_pause(this.mediaListPlayerInstance);
    }

    public void stop() {
        Logger.debug("stop()", new Object[0]);
        this.libvlc.libvlc_media_list_player_stop(this.mediaListPlayerInstance);
    }

    public boolean playItem(int itemIndex) {
        Logger.debug("playItem(itemIndex={})", itemIndex);
        return this.libvlc.libvlc_media_list_player_play_item_at_index(this.mediaListPlayerInstance, itemIndex) == 0;
    }

    public void playNext() {
        Logger.debug("playNext()", new Object[0]);
        this.libvlc.libvlc_media_list_player_next(this.mediaListPlayerInstance);
    }

    public void playPrevious() {
        Logger.debug("playPrevious()", new Object[0]);
        this.libvlc.libvlc_media_list_player_previous(this.mediaListPlayerInstance);
    }

    public boolean isPlaying() {
        Logger.debug("isPlaying()", new Object[0]);
        return this.libvlc.libvlc_media_list_player_is_playing(this.mediaListPlayerInstance) != 0;
    }

    public void setMode(MediaListPlayerMode mode) {
        libvlc_playback_mode_e playbackMode;
        Logger.debug("setMode(mode={})", new Object[]{mode});
        switch (mode) {
            case DEFAULT: {
                playbackMode = libvlc_playback_mode_e.libvlc_playback_mode_default;
                break;
            }
            case LOOP: {
                playbackMode = libvlc_playback_mode_e.libvlc_playback_mode_loop;
                break;
            }
            case REPEAT: {
                playbackMode = libvlc_playback_mode_e.libvlc_playback_mode_repeat;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode " + (Object)((Object)mode));
            }
        }
        this.libvlc.libvlc_media_list_player_set_playback_mode(this.mediaListPlayerInstance, playbackMode.intValue());
    }

    public final void release() {
        Logger.debug("release()", new Object[0]);
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance() {
        Logger.debug("createInstance()", new Object[0]);
        this.mediaListPlayerInstance = this.libvlc.libvlc_media_list_player_new(this.instance);
        this.mediaListPlayerEventManager = this.libvlc.libvlc_media_list_player_event_manager(this.mediaListPlayerInstance);
        Logger.debug("mediaListPlayerEventManager={}", this.mediaListPlayerEventManager);
        this.registerEventListener();
    }

    private void destroyInstance() {
        Logger.debug("destroyInstance()", new Object[0]);
        Logger.debug("Detach events...", new Object[0]);
        this.deregisterEventListener();
        Logger.debug("Events detached.", new Object[0]);
        this.eventListenerList.clear();
        if (this.mediaListPlayerInstance != null) {
            Logger.debug("Release media list player...", new Object[0]);
            this.libvlc.libvlc_media_list_player_release(this.mediaListPlayerInstance);
            Logger.debug("Media list player released", new Object[0]);
        }
    }

    private void registerEventListener() {
        Logger.debug("registerEventListener()", new Object[0]);
        this.callback = new VlcVideoPlayerCallback();
        for (libvlc_event_e event : libvlc_event_e.values()) {
            if (event.intValue() < libvlc_event_e.libvlc_MediaListPlayerNextItemSet.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaListPlayerNextItemSet.intValue()) continue;
            Logger.debug("event={}", new Object[]{event});
            int result = this.libvlc.libvlc_event_attach(this.mediaListPlayerEventManager, event.intValue(), this.callback, null);
            Logger.debug("result={}", result);
        }
    }

    private void deregisterEventListener() {
        Logger.debug("deregisterEventListener()", new Object[0]);
        if (this.callback != null) {
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaListPlayerNextItemSet.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaListPlayerNextItemSet.intValue()) continue;
                Logger.debug("event={}", new Object[]{event});
                this.libvlc.libvlc_event_detach(this.mediaListPlayerEventManager, event.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private void notifyListeners(libvlc_event_t event) {
        Logger.trace("notifyListeners(event={})", event);
        if (!this.eventListenerList.isEmpty()) {
            for (int i = this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaListPlayerEventListener listener = this.eventListenerList.get(i);
                int eventType = event.type;
                switch (libvlc_event_e.event(eventType)) {
                    case libvlc_MediaListPlayerNextItemSet: {
                        listener.nextItem(this);
                    }
                }
            }
        }
    }

    private final class NotifyListenersRunnable
    implements Runnable {
        private final libvlc_event_t event;

        private NotifyListenersRunnable(libvlc_event_t event) {
            this.event = event;
        }

        public void run() {
            Logger.trace("run()", new Object[0]);
            MediaListPlayer.this.notifyListeners(this.event);
            Logger.trace("runnable exits", new Object[0]);
        }
    }

    private final class VlcVideoPlayerCallback
    implements libvlc_callback_t {
        private VlcVideoPlayerCallback() {
        }

        public void callback(libvlc_event_t event, Pointer userData) {
            Logger.trace("callback(event={},userData={})", event, userData);
            if (!MediaListPlayer.this.eventListenerList.isEmpty()) {
                MediaListPlayer.this.listenersService.submit(new NotifyListenersRunnable(event));
            }
        }
    }
}

