/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import org.geotools.factory.Hints;

public final class Utilities {
    private static final String[] spaces = new String[21];
    private static final Queue<?> EMPTY_QUEUE;

    private Utilities() {
    }

    public static boolean equals(double d, double d2) {
        if (Double.doubleToLongBits(d) == Double.doubleToLongBits(d2)) {
            return true;
        }
        double d3 = Utilities.getTolerance();
        double d4 = d - Math.signum(d) * d * d3;
        double d5 = d + Math.signum(d) * d * d3;
        return d4 <= d2 && d2 <= d5;
    }

    private static double getTolerance() {
        Double d = (Double)Hints.getSystemDefault(Hints.COMPARISON_TOLERANCE);
        if (d == null) {
            return Hints.COMPARISON_TOLERANCE.getDefault();
        }
        return d;
    }

    public static boolean equals(Object object, Object object2) throws AssertionError {
        assert (object == null || !object.getClass().isArray()) : object;
        assert (object2 == null || !object2.getClass().isArray()) : object2;
        return object == object2 || object != null && object.equals(object2);
    }

    public static boolean deepEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof Object[]) {
            return object2 instanceof Object[] && Arrays.deepEquals((Object[])object, (Object[])object2);
        }
        if (object instanceof double[]) {
            return object2 instanceof double[] && Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[]) {
            return object2 instanceof float[] && Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof long[]) {
            return object2 instanceof long[] && Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof int[]) {
            return object2 instanceof int[] && Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof short[]) {
            return object2 instanceof short[] && Arrays.equals((short[])object, (short[])object2);
        }
        if (object instanceof byte[]) {
            return object2 instanceof byte[] && Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[]) {
            return object2 instanceof char[] && Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof boolean[]) {
            return object2 instanceof boolean[] && Arrays.equals((boolean[])object, (boolean[])object2);
        }
        return object.equals(object2);
    }

    public static String spaces(int n) {
        String string;
        if (n < 0) {
            n = 0;
        }
        if (n < spaces.length) {
            string = spaces[n];
            if (string == null) {
                Utilities.spaces[n] = string = spaces[spaces.length - 1].substring(0, n).intern();
            }
        } else {
            char[] cArray = new char[n];
            Arrays.fill(cArray, ' ');
            string = new String(cArray);
        }
        return string;
    }

    static {
        int n = spaces.length - 1;
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        Utilities.spaces[n] = new String(cArray).intern();
        EMPTY_QUEUE = new EmptyQueue();
    }

    private static final class EmptyQueue<E>
    extends AbstractQueue<E>
    implements Serializable {
        private static final long serialVersionUID = -6147951199761870325L;

        private EmptyQueue() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            Set set = Collections.emptySet();
            return set.iterator();
        }

        @Override
        public boolean offer(E e) {
            return false;
        }

        @Override
        public E poll() {
            return null;
        }

        @Override
        public E peek() {
            return null;
        }

        protected Object readResolve() {
            return EMPTY_QUEUE;
        }
    }
}

