/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

public class TransverseMercator
extends MapProjection {
    private static final double EPSILON = 1.0E-6;
    private static final double EPSILON_LATITUDE = 1.0E-10;
    private final double esp;
    private final double ml0;
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;

    protected TransverseMercator(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        super(parameterValueGroup);
        this.esp = this.excentricitySquared / (1.0 - this.excentricitySquared);
        this.ml0 = this.mlfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin), Math.cos(this.latitudeOfOrigin));
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    protected Point2D transformNormalized(double d, double d2, Point2D point2D) throws ProjectionException {
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = Math.abs(d4) > 1.0E-6 ? d3 / d4 : 0.0;
        d5 *= d5;
        double d6 = d4 * d;
        double d7 = d6 * d6;
        double d8 = this.esp * d4 * d4;
        d2 = this.mlfn(d2, d3, d4) - this.ml0 + d3 * (d6 /= Math.sqrt(1.0 - this.excentricitySquared * d3 * d3)) * d * 0.5 * (1.0 + 0.08333333333333333 * d7 * (5.0 - d5 + d8 * (9.0 + 4.0 * d8) + 0.03333333333333333 * d7 * (61.0 + d5 * (d5 - 58.0) + d8 * (270.0 - 330.0 * d5) + 0.017857142857142856 * d7 * (1385.0 + d5 * (d5 * (543.0 - d5) - 3111.0)))));
        d = d6 * (1.0 + 0.16666666666666666 * d7 * (1.0 - d5 + d8 + 0.05 * d7 * (5.0 + d5 * (d5 - 18.0) + d8 * (14.0 - 58.0 * d5) + 0.023809523809523808 * d7 * (61.0 + d5 * (d5 * (179.0 - d5) - 479.0)))));
        if (point2D != null) {
            point2D.setLocation(d, d2);
            return point2D;
        }
        return new Point2D.Double(d, d2);
    }

    @Override
    protected Point2D inverseTransformNormalized(double d, double d2, Point2D point2D) throws ProjectionException {
        double d3 = this.inv_mlfn(this.ml0 + d2);
        if (Math.abs(d3) >= 1.5707963267948966) {
            d2 = d2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            d = 0.0;
        } else {
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = Math.abs(d5) > 1.0E-6 ? d4 / d5 : 0.0;
            double d7 = this.esp * d5 * d5;
            double d8 = 1.0 - this.excentricitySquared * d4 * d4;
            double d9 = d * Math.sqrt(d8);
            d8 *= d6;
            d6 *= d6;
            double d10 = d9 * d9;
            d2 = d3 - d8 * d10 / (1.0 - this.excentricitySquared) * 0.5 * (1.0 - d10 * 0.08333333333333333 * (5.0 + d6 * (3.0 - 9.0 * d7) + d7 * (1.0 - 4.0 * d7) - d10 * 0.03333333333333333 * (61.0 + d6 * (90.0 - 252.0 * d7 + 45.0 * d6) + 46.0 * d7 - d10 * 0.017857142857142856 * (1385.0 + d6 * (3633.0 + d6 * (4095.0 + 1574.0 * d6))))));
            d = d9 * (1.0 - d10 * 0.16666666666666666 * (1.0 + 2.0 * d6 + d7 - d10 * 0.05 * (5.0 + d6 * (28.0 + 24.0 * d6 + 8.0 * d7) + 6.0 * d7 - d10 * 0.023809523809523808 * (61.0 + d6 * (662.0 + d6 * (1320.0 + 720.0 * d6)))))) / d5;
        }
        if (point2D != null) {
            point2D.setLocation(d, d2);
            return point2D;
        }
        return new Point2D.Double(d, d2);
    }

    @Override
    protected double getToleranceForAssertions(double d, double d2) {
        if (Math.abs(d - this.centralMeridian) > 0.26) {
            return 2.5;
        }
        if (Math.abs(d - this.centralMeridian) > 0.22) {
            return 1.0;
        }
        if (Math.abs(d - this.centralMeridian) > 0.17) {
            return 0.5;
        }
        return 1.0E-6;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.ml0);
        return ((int)l ^ (int)(l >>> 32)) + 37 * super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    public static class Provider_SouthOrientated
    extends Provider {
        public Provider_SouthOrientated() {
            super(Provider_SouthOrientated.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Transverse Mercator (South Orientated)"), new NamedIdentifier(Citations.EPSG, "9808")}));
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            MapProjection mapProjection = (MapProjection)super.createMathTransform(parameterValueGroup);
            if (mapProjection.falseEasting == 0.0 && mapProjection.falseNorthing == 0.0) {
                return mapProjection;
            }
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(-2.0 * mapProjection.falseEasting, -2.0 * mapProjection.falseNorthing);
            return ConcatenatedTransform.create(ProjectiveTransform.create(affineTransform), mapProjection);
        }
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Transverse_Mercator"), new NamedIdentifier(Citations.EPSG, "Transverse Mercator"), new NamedIdentifier(Citations.EPSG, "Gauss-Kruger"), new NamedIdentifier(Citations.EPSG, "9807"), new NamedIdentifier(Citations.GEOTIFF, "CT_TransverseMercator"), new NamedIdentifier(Citations.ESRI, "Transverse_Mercator"), new NamedIdentifier(Citations.ESRI, "Gauss_Kruger"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(225))});

        static ParameterDescriptorGroup createDescriptorGroup(ReferenceIdentifier[] referenceIdentifierArray) {
            return Provider.createDescriptorGroup(referenceIdentifierArray, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});
        }

        public Provider() {
            super(PARAMETERS);
        }

        Provider(ParameterDescriptorGroup parameterDescriptorGroup) {
            super(parameterDescriptorGroup);
        }

        public Class<CylindricalProjection> getOperationType() {
            return CylindricalProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            if (Provider.isSpherical(parameterValueGroup)) {
                return new Spherical(parameterValueGroup);
            }
            return new TransverseMercator(parameterValueGroup);
        }
    }

    private static final class Spherical
    extends TransverseMercator {
        protected Spherical(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            super(parameterValueGroup);
            this.ensureSpherical();
        }

        @Override
        protected Point2D transformNormalized(double d, double d2, Point2D point2D) throws ProjectionException {
            double d3 = d;
            assert ((point2D = super.transformNormalized(d, d2, point2D)) != null);
            double d4 = Math.cos(d2);
            double d5 = d4 * Math.sin(d);
            if (Math.abs(Math.abs(d5) - 1.0) <= 1.0E-6) {
                throw new ProjectionException(202);
            }
            d2 = Math.atan2(Math.tan(d2), Math.cos(d)) - this.latitudeOfOrigin;
            d = 0.5 * Math.log((1.0 + d5) / (1.0 - d5));
            assert (Spherical.checkTransform(d, d2, point2D, this.getToleranceForSphereAssertions(d3)));
            if (point2D != null) {
                point2D.setLocation(d, d2);
                return point2D;
            }
            return new Point2D.Double(d, d2);
        }

        @Override
        protected Point2D inverseTransformNormalized(double d, double d2, Point2D point2D) throws ProjectionException {
            assert ((point2D = super.inverseTransformNormalized(d, d2, point2D)) != null);
            double d3 = Math.sinh(d);
            double d4 = Math.cos(this.latitudeOfOrigin + d2);
            double d5 = Math.asin(Math.sqrt((1.0 - d4 * d4) / (1.0 + d3 * d3)));
            d2 = d2 + this.latitudeOfOrigin < 0.0 ? -d5 : d5;
            double d6 = d = Math.abs(d3) <= 1.0E-6 && Math.abs(d4) <= 1.0E-6 ? 0.0 : Math.atan2(d3, d4);
            assert (Spherical.checkInverseTransform(d, d2, point2D, this.getToleranceForSphereAssertions(d)));
            if (point2D != null) {
                point2D.setLocation(d, d2);
                return point2D;
            }
            return new Point2D.Double(d, d2);
        }

        protected double getToleranceForSphereAssertions(double d) {
            if (Math.abs(Math.abs(d) - 1.5707963267948966) < 1.0E-10) {
                return 1.0E18;
            }
            if (Math.abs(d) > 0.26) {
                return 1000000.0;
            }
            return 1.0E-6;
        }
    }
}

