/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.Properties;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.NameFactory;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class AbstractIdentifiedObject
extends Formattable
implements IdentifiedObject,
Serializable {
    private static final long serialVersionUID = -5173281694258483264L;
    public static final ReferenceIdentifier[] EMPTY_IDENTIFIER_ARRAY = new ReferenceIdentifier[0];
    public static final GenericName[] EMPTY_ALIAS_ARRAY = new GenericName[0];
    public static final Comparator<IdentifiedObject> NAME_COMPARATOR = new NameComparator();
    public static final Comparator<IdentifiedObject> IDENTIFIER_COMPARATOR = new IdentifierComparator();
    public static final Comparator<IdentifiedObject> REMARKS_COMPARATOR = new RemarksComparator();
    private final ReferenceIdentifier name;
    private final Collection<GenericName> alias;
    private final Set<ReferenceIdentifier> identifiers;
    private final InternationalString remarks;

    public AbstractIdentifiedObject(IdentifiedObject identifiedObject) {
        this.name = identifiedObject.getName();
        this.alias = identifiedObject.getAlias();
        this.identifiers = identifiedObject.getIdentifiers();
        this.remarks = identifiedObject.getRemarks();
    }

    public AbstractIdentifiedObject(Map<String, ?> map) throws IllegalArgumentException {
        this(map, null, null);
    }

    protected AbstractIdentifiedObject(Map<String, ?> map, Map<String, Object> map2, String[] stringArray) throws IllegalArgumentException {
        Object object;
        Object object2;
        AbstractIdentifiedObject.ensureNonNull("properties", map);
        Object object4 = null;
        GenericName[] genericNameArray = null;
        ReferenceIdentifier[] referenceIdentifierArray = null;
        Serializable serializable = null;
        Serializable serializable2 = null;
        GrowableInternationalString[] growableInternationalStringArray = null;
        block16: for (Map.Entry<String, ?> object32 : map.entrySet()) {
            object2 = object32.getKey().trim().toLowerCase();
            object = object32.getValue();
            switch (((String)object2).hashCode()) {
                case -1528693765: {
                    if (!((String)object2).equalsIgnoreCase("anchorPoint")) break;
                    object2 = "anchorPoint";
                    break;
                }
                case -1805658881: {
                    if (!((String)object2).equalsIgnoreCase("bursaWolf")) break;
                    object2 = "bursaWolf";
                    break;
                }
                case 109688209: {
                    if (!((String)object2).equalsIgnoreCase("operationVersion")) break;
                    object2 = "operationVersion";
                    break;
                }
                case 1479434472: {
                    if (!((String)object2).equalsIgnoreCase("coordinateOperationAccuracy")) break;
                    object2 = "coordinateOperationAccuracy";
                    break;
                }
                case 1126917133: {
                    if (!((String)object2).equalsIgnoreCase("positionalAccuracy")) break;
                    object2 = "positionalAccuracy";
                    break;
                }
                case 1127093059: {
                    if (!((String)object2).equalsIgnoreCase("realizationEpoch")) break;
                    object2 = "realizationEpoch";
                    break;
                }
                case 1790520781: {
                    if (!((String)object2).equalsIgnoreCase("domainOfValidity")) break;
                    object2 = "domainOfValidity";
                    break;
                }
                case -1109785975: {
                    if (!((String)object2).equalsIgnoreCase("validArea")) break;
                    object2 = "validArea";
                    break;
                }
                case 3373707: {
                    if (!((String)object2).equals("name")) break;
                    if (object instanceof String) {
                        object4 = new NamedIdentifier(map, false);
                        assert (object.equals(((Identifier)object4).getCode())) : object4;
                        continue block16;
                    }
                    object4 = object;
                    continue block16;
                }
                case 92902992: {
                    if (!((String)object2).equals("alias")) break;
                    genericNameArray = NameFactory.toArray(object);
                    continue block16;
                }
                case 1368189162: {
                    if (!((String)object2).equals("identifiers")) break;
                    if (object == null) continue block16;
                    if (object instanceof ReferenceIdentifier) {
                        referenceIdentifierArray = new ReferenceIdentifier[]{(ReferenceIdentifier)object};
                        continue block16;
                    }
                    referenceIdentifierArray = object;
                    continue block16;
                }
                case 1091415283: {
                    if (!((String)object2).equals("remarks") || !(object instanceof InternationalString)) break;
                    serializable = object;
                    continue block16;
                }
            }
            if (object instanceof String) {
                if (serializable2 == null) {
                    serializable2 = serializable instanceof GrowableInternationalString ? serializable : new GrowableInternationalString();
                }
                if (serializable2.add("remarks", (String)object2, object.toString())) continue;
            }
            if (map2 == null) continue;
            if (stringArray != null) {
                String string;
                for (int i = 0; !(i >= stringArray.length || ((String)object2).equals(string = stringArray[i]) && object instanceof InternationalString); ++i) {
                    if (!(object instanceof String)) continue;
                    if (growableInternationalStringArray == null) {
                        growableInternationalStringArray = new GrowableInternationalString[stringArray.length];
                    }
                    if (growableInternationalStringArray[i] == null) {
                        Object object3 = map2.get(string);
                        growableInternationalStringArray[i] = object3 instanceof GrowableInternationalString ? (GrowableInternationalString)object3 : new GrowableInternationalString();
                    }
                    if (growableInternationalStringArray[i].add(string, (String)object2, object.toString())) continue block16;
                }
            }
            map2.put((String)object2, object);
        }
        if (serializable2 != null && !serializable2.getLocales().isEmpty()) {
            if (serializable == null) {
                serializable = serializable2;
            } else if (!serializable2.isSubsetOf(serializable)) {
                Logger logger = Logging.getLogger(AbstractIdentifiedObject.class);
                LogRecord logRecord = Loggings.format(Level.WARNING, 28);
                logRecord.setLoggerName(logger.getName());
                logger.log(logRecord);
            }
        }
        if (map2 != null && growableInternationalStringArray != null) {
            for (int i = 0; i < growableInternationalStringArray.length; ++i) {
                serializable2 = growableInternationalStringArray[i];
                if (serializable2 == null || serializable2.getLocales().isEmpty()) continue;
                String string = stringArray[i];
                object2 = map2.get(string);
                if (object2 == null) {
                    map2.put(string, serializable2);
                    continue;
                }
                if (serializable2.isSubsetOf(object2)) continue;
                object = Logging.getLogger(AbstractIdentifiedObject.class);
                LogRecord logRecord = Loggings.format(Level.WARNING, 28);
                logRecord.setLoggerName(((Logger)object).getName());
                ((Logger)object).log(logRecord);
            }
        }
        String string = null;
        Object var11_18 = null;
        try {
            string = "name";
            Object object5 = object4;
            this.name = (ReferenceIdentifier)object5;
            string = "alias";
            GenericName[] genericNameArray2 = genericNameArray;
            this.alias = AbstractIdentifiedObject.asSet(genericNameArray);
            string = "identifiers";
            ReferenceIdentifier[] referenceIdentifierArray2 = referenceIdentifierArray;
            this.identifiers = AbstractIdentifiedObject.asSet((ReferenceIdentifier[])referenceIdentifierArray2);
            string = "remarks";
            Serializable serializable3 = serializable;
            this.remarks = (InternationalString)((Object)serializable3);
        }
        catch (ClassCastException classCastException) {
            object = new InvalidParameterValueException(Errors.format(58, string, var11_18), string, var11_18);
            ((Throwable)object).initCause(classCastException);
            throw object;
        }
        AbstractIdentifiedObject.ensureNonNull("name", object4);
        AbstractIdentifiedObject.ensureNonNull("name", object4.toString());
    }

    @Override
    public ReferenceIdentifier getName() {
        return this.name;
    }

    @Override
    public Collection<GenericName> getAlias() {
        if (this.alias == null) {
            return Collections.emptySet();
        }
        return this.alias;
    }

    @Override
    public Set<ReferenceIdentifier> getIdentifiers() {
        if (this.identifiers == null) {
            return Collections.emptySet();
        }
        return this.identifiers;
    }

    @Override
    public InternationalString getRemarks() {
        return this.remarks;
    }

    public static Map<String, ?> getProperties(IdentifiedObject identifiedObject) {
        return new Properties(identifiedObject);
    }

    public static Map<String, Object> getProperties(IdentifiedObject identifiedObject, Citation citation) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(AbstractIdentifiedObject.getProperties(identifiedObject));
        hashMap.put("name", new NamedIdentifier(citation, identifiedObject.getName().getCode()));
        hashMap.remove("identifiers");
        return hashMap;
    }

    public ReferenceIdentifier getIdentifier(Citation citation) {
        return AbstractIdentifiedObject.getIdentifier0(this, citation);
    }

    public static ReferenceIdentifier getIdentifier(IdentifiedObject identifiedObject, Citation citation) {
        if (identifiedObject instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)identifiedObject).getIdentifier(citation);
        }
        return AbstractIdentifiedObject.getIdentifier0(identifiedObject, citation);
    }

    private static ReferenceIdentifier getIdentifier0(IdentifiedObject identifiedObject, Citation citation) {
        if (identifiedObject == null) {
            return null;
        }
        for (Identifier identifier : identifiedObject.getIdentifiers()) {
            if (!(identifier instanceof ReferenceIdentifier)) continue;
            ReferenceIdentifier referenceIdentifier = (ReferenceIdentifier)identifier;
            if (citation == null) {
                return referenceIdentifier;
            }
            Citation citation2 = referenceIdentifier.getAuthority();
            if (citation2 == null || !Citations.identifierMatches(citation, citation2)) continue;
            return referenceIdentifier;
        }
        return citation == null ? identifiedObject.getName() : null;
    }

    public String getName(Citation citation) {
        return AbstractIdentifiedObject.getName0(this, citation);
    }

    public static String getName(IdentifiedObject identifiedObject, Citation citation) {
        if (identifiedObject instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)identifiedObject).getName(citation);
        }
        return AbstractIdentifiedObject.getName0(identifiedObject, citation);
    }

    private static String getName0(IdentifiedObject identifiedObject, Citation citation) {
        Identifier identifier = identifiedObject.getName();
        if (citation == null) {
            return identifier.getCode();
        }
        String string = null;
        Citation citation2 = identifier.getAuthority();
        if (citation2 != null) {
            if (Citations.identifierMatches(citation, citation2)) {
                string = identifier.getCode();
            } else {
                for (GenericName genericName : identifiedObject.getAlias()) {
                    if (genericName instanceof Identifier) {
                        identifier = (Identifier)((Object)genericName);
                        citation2 = identifier.getAuthority();
                        if (citation2 == null || !Citations.identifierMatches(citation, citation2)) continue;
                        string = identifier.getCode();
                        break;
                    }
                    GenericName genericName2 = genericName.scope().name();
                    if (genericName2 == null || !Citations.identifierMatches(citation, genericName2.toString())) continue;
                    string = genericName.tip().toString();
                    break;
                }
            }
        }
        return string;
    }

    public boolean nameMatches(String string) {
        return AbstractIdentifiedObject.nameMatches(this, this.alias, string);
    }

    public static boolean nameMatches(IdentifiedObject identifiedObject, String string) {
        if (identifiedObject instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)identifiedObject).nameMatches(string);
        }
        return AbstractIdentifiedObject.nameMatches(identifiedObject, identifiedObject.getAlias(), string);
    }

    public static boolean nameMatches(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
        return AbstractIdentifiedObject.nameMatches(identifiedObject, identifiedObject2.getName().getCode()) || AbstractIdentifiedObject.nameMatches(identifiedObject2, identifiedObject.getName().getCode());
    }

    private static boolean nameMatches(IdentifiedObject identifiedObject, Collection<GenericName> collection, String string) {
        if ((string = string.trim()).equalsIgnoreCase(identifiedObject.getName().getCode().trim())) {
            return true;
        }
        if (collection != null) {
            for (GenericName genericName : collection) {
                GenericName genericName2 = genericName.toFullyQualifiedName();
                if (genericName2 != genericName && string.equalsIgnoreCase(genericName2.toString().trim())) {
                    return true;
                }
                if (!string.equalsIgnoreCase(genericName.tip().toString().trim())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean equals(Object object) {
        return object instanceof AbstractIdentifiedObject && this.equals((AbstractIdentifiedObject)object, true);
    }

    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject != null && abstractIdentifiedObject.getClass().equals(this.getClass())) {
            if (!bl) {
                return true;
            }
            return Utilities.equals(this.name, abstractIdentifiedObject.name) && Utilities.equals(this.alias, abstractIdentifiedObject.alias) && Utilities.equals(this.identifiers, abstractIdentifiedObject.identifiers) && Utilities.equals(this.remarks, abstractIdentifiedObject.remarks);
        }
        return false;
    }

    static boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, AbstractIdentifiedObject abstractIdentifiedObject2, boolean bl) {
        return abstractIdentifiedObject == abstractIdentifiedObject2 || abstractIdentifiedObject != null && abstractIdentifiedObject.equals(abstractIdentifiedObject2, bl);
    }

    protected static boolean equals(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2, boolean bl) {
        if (!(identifiedObject instanceof AbstractIdentifiedObject)) {
            return Utilities.equals(identifiedObject, identifiedObject2);
        }
        if (!(identifiedObject2 instanceof AbstractIdentifiedObject)) {
            return Utilities.equals(identifiedObject2, identifiedObject);
        }
        return AbstractIdentifiedObject.equals((AbstractIdentifiedObject)identifiedObject, (AbstractIdentifiedObject)identifiedObject2, bl);
    }

    protected static boolean equals(IdentifiedObject[] identifiedObjectArray, IdentifiedObject[] identifiedObjectArray2, boolean bl) {
        if (identifiedObjectArray != identifiedObjectArray2) {
            if (identifiedObjectArray == null || identifiedObjectArray2 == null || identifiedObjectArray.length != identifiedObjectArray2.length) {
                return false;
            }
            int n = identifiedObjectArray.length;
            while (--n >= 0) {
                if (AbstractIdentifiedObject.equals(identifiedObjectArray[n], identifiedObjectArray2[n], bl)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean equals(Collection<? extends IdentifiedObject> collection, Collection<? extends IdentifiedObject> collection2, boolean bl) {
        if (collection == collection2) {
            return true;
        }
        if (collection == null || collection2 == null) {
            return false;
        }
        Iterator<? extends IdentifiedObject> iterator = collection.iterator();
        Iterator<? extends IdentifiedObject> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            if (iterator2.hasNext() && AbstractIdentifiedObject.equals(iterator.next(), iterator2.next(), bl)) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    private static <E extends Comparable<E>> int doCompare(E e, E e2) {
        if (e == null) {
            return e2 == null ? 0 : -1;
        }
        if (e2 == null) {
            return 1;
        }
        return e.compareTo(e2);
    }

    public int hashCode() {
        return 0x52B12FC0 ^ this.getClass().hashCode();
    }

    protected static <E> Set<E> asSet(E[] EArray) {
        if (EArray == null) {
            return null;
        }
        switch (EArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return Collections.singleton(EArray[0]);
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(EArray)));
    }

    protected static void ensureNonNull(String string, Object object) throws InvalidParameterValueException {
        if (object == null) {
            throw new InvalidParameterValueException(Errors.format(143, string), string, object);
        }
    }

    protected static void ensureNonNull(String string, Object[] objectArray, int n) throws InvalidParameterValueException {
        if (objectArray[n] == null) {
            throw new InvalidParameterValueException(Errors.format(143, string + '[' + n + ']'), string, objectArray);
        }
    }

    protected static void ensureTimeUnit(Unit<?> unit) throws IllegalArgumentException {
        if (!SI.SECOND.isCompatible(unit)) {
            throw new IllegalArgumentException(Errors.format(117, unit));
        }
    }

    protected static void ensureLinearUnit(Unit<?> unit) throws IllegalArgumentException {
        if (!SI.METER.isCompatible(unit)) {
            throw new IllegalArgumentException(Errors.format(113, unit));
        }
    }

    protected static void ensureAngularUnit(Unit<?> unit) throws IllegalArgumentException {
        if (!SI.RADIAN.isCompatible(unit) && !Unit.ONE.equals(unit)) {
            throw new IllegalArgumentException(Errors.format(107, unit));
        }
    }

    private static final class RemarksComparator
    implements Comparator<IdentifiedObject>,
    Serializable {
        private static final long serialVersionUID = -6675419613224162715L;

        private RemarksComparator() {
        }

        @Override
        public int compare(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
            return AbstractIdentifiedObject.doCompare(identifiedObject.getRemarks(), identifiedObject2.getRemarks());
        }

        protected Object readResolve() throws ObjectStreamException {
            return REMARKS_COMPARATOR;
        }
    }

    private static final class IdentifierComparator
    implements Comparator<IdentifiedObject>,
    Serializable {
        private static final long serialVersionUID = -7315726806679993522L;

        private IdentifierComparator() {
        }

        @Override
        public int compare(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
            boolean bl;
            boolean bl2;
            Set<ReferenceIdentifier> set = identifiedObject.getIdentifiers();
            Set<ReferenceIdentifier> set2 = identifiedObject2.getIdentifiers();
            if (set == null) {
                set = Collections.emptySet();
            }
            if (set2 == null) {
                set2 = Collections.emptySet();
            }
            Iterator iterator = set.iterator();
            Iterator iterator2 = set2.iterator();
            while ((bl2 = iterator.hasNext()) & (bl = iterator2.hasNext())) {
                int n = AbstractIdentifiedObject.doCompare((Comparable)((Object)((ReferenceIdentifier)iterator.next()).getCode()), (Comparable)((Object)((ReferenceIdentifier)iterator2.next()).getCode()));
                if (n == 0) continue;
                return n;
            }
            if (bl2) {
                return 1;
            }
            if (bl) {
                return -1;
            }
            return 0;
        }

        protected Object readResolve() throws ObjectStreamException {
            return IDENTIFIER_COMPARATOR;
        }
    }

    private static final class NameComparator
    implements Comparator<IdentifiedObject>,
    Serializable {
        private static final long serialVersionUID = -6605097017814062198L;

        private NameComparator() {
        }

        @Override
        public int compare(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
            return AbstractIdentifiedObject.doCompare((Comparable)((Object)identifiedObject.getName().getCode()), (Comparable)((Object)identifiedObject2.getName().getCode()));
        }

        protected Object readResolve() throws ObjectStreamException {
            return NAME_COMPARATOR;
        }
    }
}

