/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class FilteredIterator<F extends Feature>
implements Iterator<F> {
    private FeatureCollection<? extends FeatureType, F> collection;
    private Iterator<F> delegate;
    private Filter filter;
    private F next;

    public FilteredIterator(FeatureCollection<? extends FeatureType, F> featureCollection, Filter filter) {
        this.collection = featureCollection;
        this.delegate = featureCollection.iterator();
        this.filter = filter;
        this.next = this.getNext();
    }

    void close() {
        if (this.collection != null) {
            this.collection.close(this.delegate);
        }
        this.collection = null;
        this.delegate = null;
        this.filter = null;
        this.next = null;
    }

    private F getNext() {
        Feature feature = null;
        while (this.delegate.hasNext()) {
            feature = (Feature)this.delegate.next();
            if (!this.filter.evaluate(feature)) continue;
            return (F)feature;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public F next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        F f = this.next;
        this.next = this.getNext();
        return f;
    }

    @Override
    public void remove() {
        if (this.delegate == null) {
            throw new IllegalStateException();
        }
        this.delegate.remove();
    }
}

