/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataUtilities;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.resources.Classes;
import org.geotools.util.SimpleInternationalString;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class AttributeTypeBuilder {
    protected FeatureTypeFactory factory;
    protected String name;
    private String separator = ":";
    protected String namespaceURI;
    protected boolean isAbstract = false;
    protected List<Filter> restrictions;
    protected String description;
    protected boolean isIdentifiable = false;
    protected Class binding;
    protected AttributeType superType;
    protected Object defaultValue;
    protected boolean isDefaultValueSet = false;
    protected CoordinateReferenceSystem crs;
    protected boolean isCrsSet = false;
    protected Integer minOccurs = null;
    protected Integer maxOccurs = null;
    protected boolean isNillable = true;
    protected Map userData = null;

    public AttributeTypeBuilder() {
        this(new FeatureTypeFactoryImpl());
        this.init();
    }

    public AttributeTypeBuilder(FeatureTypeFactory featureTypeFactory) {
        this.factory = featureTypeFactory;
        this.init();
    }

    protected void init() {
        this.resetTypeState();
        this.resetDescriptorState();
    }

    protected void resetTypeState() {
        this.name = null;
        this.namespaceURI = null;
        this.isAbstract = false;
        this.restrictions = null;
        this.description = null;
        this.isIdentifiable = false;
        this.binding = null;
        this.defaultValue = null;
        this.superType = null;
        this.crs = null;
        this.isCrsSet = false;
        this.isDefaultValueSet = false;
    }

    protected void resetDescriptorState() {
        this.minOccurs = null;
        this.maxOccurs = null;
        this.isNillable = true;
        this.userData = new HashMap();
    }

    public AttributeTypeBuilder init(AttributeType attributeType) {
        this.name = attributeType.getName().getLocalPart();
        this.separator = attributeType.getName().getSeparator();
        this.namespaceURI = attributeType.getName().getNamespaceURI();
        this.isAbstract = attributeType.isAbstract();
        if (attributeType.getRestrictions() != null) {
            this.restrictions().addAll(attributeType.getRestrictions());
        }
        this.description = attributeType.getDescription() != null ? attributeType.getDescription().toString() : null;
        this.isIdentifiable = attributeType.isIdentified();
        this.binding = attributeType.getBinding();
        this.superType = attributeType.getSuper();
        if (attributeType instanceof GeometryType) {
            this.crs = ((GeometryType)attributeType).getCoordinateReferenceSystem();
        }
        return this;
    }

    public void init(AttributeDescriptor attributeDescriptor) {
        this.init(attributeDescriptor.getType());
        this.minOccurs = attributeDescriptor.getMinOccurs();
        this.maxOccurs = attributeDescriptor.getMaxOccurs();
        this.isNillable = attributeDescriptor.isNillable();
    }

    public void setBinding(Class clazz) {
        this.binding = clazz;
        if (!this.isDefaultValueSet) {
            try {
                this.defaultValue = DataUtilities.defaultValue(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.crs = coordinateReferenceSystem;
        this.isCrsSet = true;
    }

    public boolean isCRSSet() {
        return this.isCrsSet;
    }

    public void setLength(int n) {
    }

    public void addUserData(Object object, Object object2) {
        this.userData.put(object, object2);
    }

    public void setNillable(boolean bl) {
        this.isNillable = bl;
    }

    public void setMaxOccurs(int n) {
        this.maxOccurs = n;
    }

    public void setMinOccurs(int n) {
        this.minOccurs = n;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
        this.isDefaultValueSet = true;
    }

    public AttributeType buildType() {
        AttributeType attributeType = this.factory.createAttributeType(this.name(), this.binding, this.isIdentifiable, this.isAbstract, this.restrictions(), this.superType, this.description());
        this.resetTypeState();
        return attributeType;
    }

    protected String typeName() {
        if (this.name == null) {
            return Classes.getShortName(this.binding);
        }
        return this.name;
    }

    private InternationalString description() {
        return this.description != null ? new SimpleInternationalString(this.description) : null;
    }

    public GeometryType buildGeometryType() {
        GeometryType geometryType = this.factory.createGeometryType(this.name(), this.binding, this.crs, this.isIdentifiable, this.isAbstract, this.restrictions(), this.superType, this.description());
        this.resetTypeState();
        return geometryType;
    }

    public AttributeDescriptor buildDescriptor(String string) {
        this.setName(string);
        if (this.binding == null) {
            throw new IllegalStateException("No binding has been provided for this attribute");
        }
        if (this.crs != null || Geometry.class.isAssignableFrom(this.binding)) {
            return this.buildDescriptor(string, this.buildGeometryType());
        }
        return this.buildDescriptor(string, this.buildType());
    }

    public AttributeDescriptor buildDescriptor(String string, AttributeType attributeType) {
        return this.buildDescriptor((Name)new NameImpl(string), attributeType);
    }

    public GeometryDescriptor buildDescriptor(String string, GeometryType geometryType) {
        return this.buildDescriptor((Name)new NameImpl(string), geometryType);
    }

    public AttributeDescriptor buildDescriptor(Name name, AttributeType attributeType) {
        AttributeDescriptor attributeDescriptor = this.factory.createAttributeDescriptor(attributeType, name, this.minOccurs(), this.maxOccurs(), this.isNillable, this.defaultValue());
        attributeDescriptor.getUserData().putAll(this.userData);
        this.resetDescriptorState();
        return attributeDescriptor;
    }

    public GeometryDescriptor buildDescriptor(Name name, GeometryType geometryType) {
        GeometryDescriptor geometryDescriptor = this.factory.createGeometryDescriptor(geometryType, name, this.minOccurs(), this.maxOccurs(), this.isNillable, this.defaultValue());
        geometryDescriptor.getUserData().putAll(this.userData);
        this.resetDescriptorState();
        return geometryDescriptor;
    }

    private int minOccurs() {
        if (this.minOccurs == null) {
            return this.isNillable ? 0 : 1;
        }
        return this.minOccurs;
    }

    private int maxOccurs() {
        if (this.maxOccurs == null) {
            return 1;
        }
        return this.maxOccurs;
    }

    private Name name() {
        if (this.separator == null) {
            return new NameImpl(this.namespaceURI, this.typeName());
        }
        return new NameImpl(this.namespaceURI, this.separator, this.typeName());
    }

    private Object defaultValue() {
        if (this.defaultValue == null && !this.isNillable && this.binding != null) {
            this.defaultValue = DataUtilities.defaultValue(this.binding);
        }
        return this.defaultValue;
    }

    protected List<Filter> restrictions() {
        if (this.restrictions == null) {
            this.restrictions = new ArrayList<Filter>();
        }
        return this.restrictions;
    }
}

