/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Diff;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public abstract class AbstractFeatureSource
implements SimpleFeatureSource {
    protected Set hints = Collections.EMPTY_SET;
    protected QueryCapabilities queryCapabilities = new QueryCapabilities();

    public AbstractFeatureSource() {
    }

    public abstract DataStore getDataStore();

    @Override
    public Name getName() {
        return ((SimpleFeatureType)this.getSchema()).getName();
    }

    public AbstractFeatureSource(Set set) {
        this.hints = Collections.unmodifiableSet(new HashSet(set));
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return this.queryCapabilities;
    }

    public Transaction getTransaction() {
        return Transaction.AUTO_COMMIT;
    }

    @Override
    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        Object object;
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)this.getSchema();
        String string = simpleFeatureType.getTypeName();
        if (query.getTypeName() == null) {
            object = new DefaultQuery(query);
            ((Query)object).setTypeName(string);
        } else if (!string.equals(query.getTypeName())) {
            return new EmptyFeatureCollection(simpleFeatureType);
        }
        object = this.getQueryCapabilities();
        if (!((QueryCapabilities)object).supportsSorting(query.getSortBy())) {
            throw new DataSourceException("DataStore cannot provide the requested sort order");
        }
        DefaultFeatureResults defaultFeatureResults = new DefaultFeatureResults(this, query);
        if (((SimpleFeatureType)defaultFeatureResults.getSchema()).getGeometryDescriptor() == null) {
            return defaultFeatureResults;
        }
        return defaultFeatureResults;
    }

    @Override
    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    @Override
    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Filter.INCLUDE);
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(this.getSchema() == null ? Query.ALL : new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName()));
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return new ReferencedEnvelope(new Envelope(), ((SimpleFeatureType)this.getSchema()).getCoordinateReferenceSystem());
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return null;
        }
        return ((AbstractDataStore)dataStore).getBounds(this.namedQuery(query));
    }

    protected Query namedQuery(Query query) {
        String string = ((SimpleFeatureType)this.getSchema()).getTypeName();
        if (query.getTypeName() == null || !query.getTypeName().equals(string)) {
            return new DefaultQuery(string, query.getFilter(), query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return 0;
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return -1;
        }
        Transaction transaction = this.getTransaction();
        int n = ((AbstractDataStore)dataStore).getCount(this.namedQuery(query));
        if (n == -1) {
            return -1;
        }
        int n2 = 0;
        if (transaction != Transaction.AUTO_COMMIT) {
            Diff diff;
            if (transaction.getState(dataStore) == null) {
                return n;
            }
            if (!(transaction.getState(dataStore) instanceof TransactionStateDiff)) {
                return -1;
            }
            Diff diff2 = diff = ((AbstractDataStore)dataStore).state(transaction).diff(this.namedQuery(query).getTypeName());
            synchronized (diff2) {
                for (Object v : diff.added.values()) {
                    if (!query.getFilter().evaluate(v)) continue;
                    ++n2;
                }
                for (Object v : diff.modified2.values()) {
                    if (v != TransactionStateDiff.NULL || !query.getFilter().evaluate(v)) continue;
                    --n2;
                }
            }
        }
        return n + n2;
    }

    @Override
    public Set getSupportedHints() {
        return this.hints;
    }
}

