/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.plugins.graphview.core.graph.EvaluationGroup;
import org.openstreetmap.josm.plugins.graphview.core.transition.Restriction;
import org.openstreetmap.josm.plugins.graphview.core.transition.Segment;
import org.openstreetmap.josm.plugins.graphview.core.transition.SegmentNode;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunctionEvaluationGroup
extends EvaluationGroup {
    private final Set<SegmentNode> segmentNodes;
    protected List<Segment> inboundSegments;
    protected List<Segment> outboundSegments;

    public JunctionEvaluationGroup(Set<SegmentNode> segmentNodes) {
        assert (segmentNodes != null);
        this.segmentNodes = segmentNodes;
    }

    public Collection<Segment> getInboundSegments() {
        if (!this.evaluated) {
            throw new IllegalStateException(I18n.tr((String)"Group not yet evaluated", (Object[])new Object[0]));
        }
        return this.inboundSegments;
    }

    public Collection<Segment> getOutboundSegments() {
        if (!this.evaluated) {
            throw new IllegalStateException(I18n.tr((String)"Group not yet evaluated", (Object[])new Object[0]));
        }
        return this.outboundSegments;
    }

    public List<Segment> getSegmentSequence(Segment inboundSegment, Segment outboundSegment) {
        assert (inboundSegment != null && this.inboundSegments.contains(inboundSegment));
        assert (outboundSegment != null && this.outboundSegments.contains(outboundSegment));
        if (!this.evaluated) {
            throw new IllegalStateException(I18n.tr((String)"Group not yet evaluated", (Object[])new Object[0]));
        }
        int inboundIndex = this.inboundSegments.indexOf(inboundSegment);
        int outboundIndex = this.outboundSegments.indexOf(outboundSegment);
        return this.segmentSequences[inboundIndex][outboundIndex];
    }

    @Override
    protected void evaluateImpl(Collection<Restriction> restrictions) {
        assert (restrictions != null);
        this.inboundSegments = new ArrayList<Segment>();
        this.outboundSegments = new ArrayList<Segment>();
        for (SegmentNode segmentNode : this.segmentNodes) {
            for (Segment segment : segmentNode.getInboundSegments()) {
                if (this.segmentNodes.contains(segment.getNode1())) continue;
                this.inboundSegments.add(segment);
            }
            for (Segment segment : segmentNode.getOutboundSegments()) {
                if (this.segmentNodes.contains(segment.getNode2())) continue;
                this.outboundSegments.add(segment);
            }
        }
        List[][] sequenceArray = new List[this.inboundSegments.size()][this.outboundSegments.size()];
        for (int inboundIndex = 0; inboundIndex < this.inboundSegments.size(); ++inboundIndex) {
            for (int outboundIndex = 0; outboundIndex < this.outboundSegments.size(); ++outboundIndex) {
                List<Segment> sequence;
                sequenceArray[inboundIndex][outboundIndex] = sequence = this.findSegmentSequence(this.inboundSegments.get(inboundIndex), this.outboundSegments.get(outboundIndex), restrictions);
            }
        }
        this.segmentSequences = sequenceArray;
    }

    @Override
    protected boolean isUsableNode(SegmentNode node) {
        return this.segmentNodes.contains(node);
    }

    @Override
    protected boolean isUsableSegment(Segment segment) {
        return this.segmentNodes.contains(segment.getNode1()) && this.segmentNodes.contains(segment.getNode2());
    }

    public String toString() {
        return "JunctionEG " + this.segmentNodes;
    }
}

