/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.preset.io;

import java.io.File;
import java.io.Reader;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.josm.plugins.tageditor.preset.Group;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.plugins.tageditor.preset.Presets;
import org.openstreetmap.josm.plugins.tageditor.preset.Tag;
import org.openstreetmap.josm.plugins.tageditor.preset.io.PresetIOException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Parser {
    private static final Logger logger = Logger.getLogger(Parser.class.getName());
    private Presets presets = null;
    private Reader reader;
    private Stack<Group> currentGroup = new Stack();
    private Item currentItem = null;
    private boolean inOptionalKeys = false;
    private XMLReader parser;
    private File zipIconArchive;

    public Parser() {
    }

    public Parser(Reader reader) {
        this();
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        this.reader = reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setZipIconArchive(File zipIconArchive) {
        this.zipIconArchive = zipIconArchive;
    }

    public Presets getPresets() {
        return this.presets;
    }

    public void setPresets(Presets presets) {
        this.presets = presets;
    }

    protected void init() throws PresetIOException {
        try {
            this.parser = XMLReaderFactory.createXMLReader();
            Handler handler = new Handler();
            this.parser.setContentHandler(handler);
            this.parser.setErrorHandler(handler);
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.parser.setFeature("http://xml.org/sax/features/namespaces", false);
            this.parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "exception while creating SAX parser", e);
            throw new PresetIOException("exception while creating SAX parser", e);
        }
    }

    public void parse() throws PresetIOException {
        if (this.getReader() == null) {
            throw new IllegalStateException("reader is null. set reader first.");
        }
        if (this.getPresets() == null) {
            logger.warning("presets is null. Creating a new set of presets");
            this.setPresets(new Presets());
        }
        this.parse(this.getReader());
    }

    public void parse(Reader reader) throws PresetIOException {
        this.init();
        if (this.getPresets() == null) {
            logger.warning("presets is null. Creating a new set of presets");
            this.setPresets(new Presets());
        }
        try {
            this.parser.parse(new InputSource(reader));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "exception while parsing preset file", e);
            throw new PresetIOException(e);
        }
        this.parser = null;
    }

    protected String translatedAttributeValue(String attrValue) {
        if (attrValue == null) {
            return null;
        }
        return I18n.tr((String)attrValue, (Object[])new Object[0]);
    }

    protected void onStartGroup(String name, String iconName) {
        Group g = new Group();
        g.setName(this.translatedAttributeValue(name));
        g.setIconName(iconName, this.zipIconArchive);
        this.currentGroup.push(g);
    }

    protected void onEndGroup() {
        Group g = this.currentGroup.pop();
        this.presets.addGroup(g);
    }

    protected void onStartItem(String name, String iconName) {
        this.currentItem = new Item();
        this.currentItem.setName(this.translatedAttributeValue(name));
        this.currentItem.setIconName(iconName, this.zipIconArchive);
    }

    protected void onEndItem() {
        if (this.currentGroup == null) {
            logger.log(Level.SEVERE, "illegal state. no current group defined");
            throw new IllegalStateException("illegal state. no current group defined");
        }
        this.currentGroup.peek().addItem(this.currentItem);
        this.currentItem = null;
    }

    protected void onStartOptionalKeys() {
        this.inOptionalKeys = true;
    }

    protected void onEndOptionalKeys() {
        this.inOptionalKeys = false;
    }

    protected void onTag(String key, String value, String displayName) {
        Tag tag = new Tag();
        tag.setKey(key);
        tag.setValue(value);
        tag.setDisplayName(this.translatedAttributeValue(displayName));
        tag.setOptional(this.inOptionalKeys);
        if (this.currentItem == null) {
            logger.log(Level.SEVERE, "illegal state. no current item defined");
            throw new IllegalStateException("illegal state. no current item defined");
        }
        this.currentItem.addTag(tag);
    }

    protected void onLabel(String label) {
        if (this.currentItem == null) {
            logger.log(Level.SEVERE, "illegal state. no current item defined");
            throw new IllegalStateException("illegal state. no current item defined");
        }
        this.currentItem.setLabel(label);
    }

    class Handler
    extends DefaultHandler {
        Handler() {
        }

        public void endDocument() throws SAXException {
            logger.log(Level.FINE, "END");
        }

        public void error(SAXParseException e) throws SAXException {
            logger.log(Level.SEVERE, "XML parsing error", e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            logger.log(Level.SEVERE, "XML parsing error", e);
        }

        public void startDocument() throws SAXException {
            logger.log(Level.FINE, "START");
        }

        protected String getAttribute(Attributes attributes, String qName) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals(qName)) continue;
                return attributes.getValue(i);
            }
            return null;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if ("group".equals(qName)) {
                Parser.this.onStartGroup(this.getAttribute(atts, "name"), this.getAttribute(atts, "icon"));
            } else if ("item".equals(qName)) {
                Parser.this.onStartItem(this.getAttribute(atts, "name"), this.getAttribute(atts, "icon"));
            } else if ("label".equals(qName)) {
                Parser.this.onLabel(this.getAttribute(atts, "text"));
            } else if ("optional".equals(qName)) {
                Parser.this.onStartOptionalKeys();
            } else if ("key".equals(qName) || "text".equals(qName) || "combo".equals(qName) || "check".equals(qName)) {
                Parser.this.onTag(this.getAttribute(atts, "key"), this.getAttribute(atts, "value"), this.getAttribute(atts, "text"));
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if ("group".equals(qName)) {
                Parser.this.onEndGroup();
            } else if ("item".equals(qName)) {
                Parser.this.onEndItem();
            } else if (!"label".equals(qName) && "optional".equals(qName)) {
                Parser.this.onEndOptionalKeys();
            }
        }

        public void warning(SAXParseException e) throws SAXException {
            logger.log(Level.WARNING, "XML parsing warning", e);
        }
    }
}

