/*
 * Decompiled with CFR 0.152.
 */
package com.tilusnet.josm.plugins.alignways;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.I18n;

public class AlignWaysSegment
implements MapViewPaintable {
    protected WaySegment segment;
    protected MapView mapview;
    protected Color segmentColor = Color.WHITE;
    protected Collection<Node> segmentEndPoints;

    public AlignWaysSegment(MapView mapview, Point p) throws IllegalArgumentException {
        if (mapview == null) {
            throw new IllegalArgumentException(I18n.tr((String)"Parameter ''{0}'' must not be null", (Object[])new Object[]{"mapview"}));
        }
        if (p == null) {
            throw new IllegalArgumentException(I18n.tr((String)"Parameter ''{0}'' must not be null", (Object[])new Object[]{"p"}));
        }
        this.mapview = mapview;
    }

    void setSegment(WaySegment segment) {
        this.segment = segment;
        if (segment != null) {
            this.setSegmentEndpoints(segment);
            this.mapview.addTemporaryLayer((MapViewPaintable)this);
        }
    }

    void setSegmentEndpoints(WaySegment segment) {
        if (segment != null) {
            Node node1 = segment.way.getNode(segment.lowerIndex);
            Node node2 = segment.way.getNode(segment.lowerIndex + 1);
            this.segmentEndPoints = new HashSet<Node>();
            this.segmentEndPoints.add(node1);
            this.segmentEndPoints.add(node2);
        }
    }

    protected WaySegment getNearestWaySegment(Point p) {
        return this.mapview.getNearestWaySegment(p, OsmPrimitive.isUsablePredicate);
    }

    public void destroy() {
        if (this.segment != null) {
            this.mapview.removeTemporaryLayer((MapViewPaintable)this);
        }
    }

    public WaySegment getSegment() {
        return this.segment;
    }

    public Collection<Node> getSegmentEndPoints() {
        return this.segmentEndPoints;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        this.highlightSegment(this.segmentColor, g, mv);
    }

    protected void highlightSegment(Color c, Graphics2D g, MapView mv) {
        g.setColor(c);
        g.setStroke(new BasicStroke(6.0f, 1, 1));
        this.drawSegment(g, mv);
    }

    protected void drawSegment(Graphics2D g, MapView mv) {
        Node n1 = this.segment.way.getNode(this.segment.lowerIndex);
        Node n2 = this.segment.way.getNode(this.segment.lowerIndex + 1);
        Line2D.Double newline = new Line2D.Double(mv.getPoint(n1), mv.getPoint(n2));
        g.draw(newline);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.segment == null ? 0 : this.segment.hashCode());
        result = 31 * result + (this.segmentColor == null ? 0 : this.segmentColor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlignWaysSegment)) {
            return false;
        }
        AlignWaysSegment other = (AlignWaysSegment)obj;
        return !(this.segment == null ? other.segment != null : !this.segment.equals((Object)other.segment));
    }
}

