/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ZipReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmzReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.TabReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.OdsReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.XlsReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class NetworkReader
extends OsmServerReader
implements OdConstants {
    private final String url;
    private final AbstractDataSetHandler handler;
    private Class<? extends AbstractReader> readerClass;
    private final boolean promptUser;
    private File file;
    private String filename;

    public NetworkReader(String url, AbstractDataSetHandler handler, boolean promptUser) {
        CheckParameterUtil.ensureParameterNotNull((Object)url, (String)"url");
        this.url = url;
        this.handler = handler;
        this.readerClass = null;
        this.promptUser = promptUser;
    }

    public final File getReadFile() {
        return this.file;
    }

    public final String getReadFileName() {
        return this.filename;
    }

    private Class<? extends AbstractReader> findReaderByAttachment() {
        Matcher m;
        String cdisp = this.activeConnection.getHeaderField("Content-disposition");
        if (cdisp != null && (m = Pattern.compile("attachment;.?filename=(.*)").matcher(cdisp)).matches()) {
            this.filename = m.group(1);
            return this.findReaderByExtension(this.filename.toLowerCase());
        }
        return null;
    }

    private Class<? extends AbstractReader> findReaderByContentType() {
        String contentType = this.activeConnection.getContentType();
        if (contentType.startsWith("application/zip")) {
            return ZipReader.class;
        }
        if (contentType.startsWith("application/vnd.ms-excel")) {
            return XlsReader.class;
        }
        if (!contentType.startsWith("application/octet-stream")) {
            if (contentType.startsWith("text/csv")) {
                return CsvReader.class;
            }
            if (contentType.startsWith("text/plain")) {
                return CsvReader.class;
            }
            if (!contentType.startsWith("tdyn/html")) {
                System.err.println("Unsupported content type: " + contentType);
            }
        }
        return null;
    }

    private Class<? extends AbstractReader> findReaderByExtension(String filename) {
        if ((filename = filename.replace("\"", "")).endsWith(".xls")) {
            return XlsReader.class;
        }
        if (filename.endsWith(".csv")) {
            return CsvReader.class;
        }
        if (filename.endsWith(".ods")) {
            return OdsReader.class;
        }
        if (filename.endsWith(".kml")) {
            return KmlReader.class;
        }
        if (filename.endsWith(".kmz")) {
            return KmzReader.class;
        }
        if (filename.endsWith(".mif")) {
            return MifReader.class;
        }
        if (filename.endsWith(".shp")) {
            return ShpReader.class;
        }
        if (filename.endsWith(".tab")) {
            return TabReader.class;
        }
        if (filename.endsWith(".gml")) {
            return GmlReader.class;
        }
        if (filename.endsWith(".zip")) {
            return ZipReader.class;
        }
        return null;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        InputStream in;
        block72: {
            ProgressMonitor instance;
            block71: {
                block70: {
                    block69: {
                        block68: {
                            block67: {
                                block66: {
                                    block65: {
                                        block64: {
                                            block63: {
                                                block62: {
                                                    in = null;
                                                    instance = null;
                                                    in = this.getInputStreamRaw(this.url, progressMonitor);
                                                    if (in != null) break block62;
                                                    DataSet dataSet = null;
                                                    progressMonitor.finishTask();
                                                    try {
                                                        this.activeConnection = null;
                                                        if (in != null) {
                                                            in.close();
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        // empty catch block
                                                    }
                                                    return dataSet;
                                                }
                                                progressMonitor.subTask(I18n.tr((String)"Downloading data...", (Object[])new Object[0]));
                                                if (this.readerClass == null) {
                                                    this.readerClass = this.findReaderByAttachment();
                                                }
                                                if (this.readerClass == null) {
                                                    this.readerClass = this.findReaderByContentType();
                                                }
                                                if (this.readerClass == null) {
                                                    this.readerClass = this.findReaderByExtension(this.url.toLowerCase());
                                                }
                                                if (this.readerClass == null) {
                                                    throw new OsmTransferException("Cannot find appropriate reader !");
                                                }
                                                if (this.findReaderByExtension(this.url.toLowerCase()) != null) {
                                                    this.filename = this.url.substring(this.url.lastIndexOf(47) + 1);
                                                }
                                                instance = progressMonitor.createSubTaskMonitor(-1, false);
                                                if (!this.readerClass.equals(ZipReader.class)) break block63;
                                                ZipReader zipReader = new ZipReader(in, this.handler, this.promptUser);
                                                DataSet ds = zipReader.parseDoc(instance);
                                                this.file = zipReader.getReadFile();
                                                DataSet dataSet = ds;
                                                progressMonitor.finishTask();
                                                try {
                                                    this.activeConnection = null;
                                                    if (in != null) {
                                                        in.close();
                                                    }
                                                }
                                                catch (Exception e) {
                                                    // empty catch block
                                                }
                                                return dataSet;
                                            }
                                            if (!this.readerClass.equals(KmlReader.class)) break block64;
                                            DataSet zipReader = KmlReader.parseDataSet(in, instance);
                                            progressMonitor.finishTask();
                                            try {
                                                this.activeConnection = null;
                                                if (in != null) {
                                                    in.close();
                                                }
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                            return zipReader;
                                        }
                                        if (!this.readerClass.equals(KmzReader.class)) break block65;
                                        DataSet zipReader = KmzReader.parseDataSet(in, instance);
                                        progressMonitor.finishTask();
                                        try {
                                            this.activeConnection = null;
                                            if (in != null) {
                                                in.close();
                                            }
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        return zipReader;
                                    }
                                    if (!this.readerClass.equals(MifReader.class)) break block66;
                                    DataSet zipReader = MifReader.parseDataSet(in, null, this.handler, instance);
                                    progressMonitor.finishTask();
                                    try {
                                        this.activeConnection = null;
                                        if (in != null) {
                                            in.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    return zipReader;
                                }
                                if (!this.readerClass.equals(ShpReader.class)) break block67;
                                DataSet zipReader = ShpReader.parseDataSet(in, null, this.handler, instance);
                                progressMonitor.finishTask();
                                try {
                                    this.activeConnection = null;
                                    if (in != null) {
                                        in.close();
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                return zipReader;
                            }
                            if (!this.readerClass.equals(TabReader.class)) break block68;
                            DataSet zipReader = TabReader.parseDataSet(in, null, this.handler, instance);
                            progressMonitor.finishTask();
                            try {
                                this.activeConnection = null;
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return zipReader;
                        }
                        if (!this.readerClass.equals(CsvReader.class)) break block69;
                        DataSet zipReader = CsvReader.parseDataSet(in, this.handler, instance);
                        progressMonitor.finishTask();
                        try {
                            this.activeConnection = null;
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return zipReader;
                    }
                    if (!this.readerClass.equals(OdsReader.class)) break block70;
                    DataSet zipReader = OdsReader.parseDataSet(in, this.handler, instance);
                    progressMonitor.finishTask();
                    try {
                        this.activeConnection = null;
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return zipReader;
                }
                if (!this.readerClass.equals(XlsReader.class)) break block71;
                DataSet zipReader = XlsReader.parseDataSet(in, this.handler, instance);
                progressMonitor.finishTask();
                try {
                    this.activeConnection = null;
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return zipReader;
            }
            if (!this.readerClass.equals(GmlReader.class)) break block72;
            DataSet zipReader = GmlReader.parseDataSet(in, this.handler, instance);
            progressMonitor.finishTask();
            try {
                this.activeConnection = null;
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return zipReader;
        }
        try {
            try {
                throw new IllegalArgumentException("Unsupported reader class: " + this.readerClass.getName());
            }
            catch (OsmTransferException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.cancel) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                throw new OsmTransferException((Throwable)e);
            }
        }
        finally {
            progressMonitor.finishTask();
            try {
                this.activeConnection = null;
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

