/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.ArrayList;
import org.geotools.resources.Classes;
import org.geotools.util.LocalName;
import org.geotools.util.ScopedName;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;

public final class NameFactory {
    private NameFactory() {
    }

    public static GenericName create(String string) {
        return NameFactory.create(string, ':');
    }

    public static GenericName create(String string, char c) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while ((n = string.indexOf(c, n2)) >= 0) {
            arrayList.add(string.substring(n2, n));
            n2 = n + 1;
        }
        arrayList.add(string.substring(n2));
        return NameFactory.create(arrayList.toArray(new String[arrayList.size()]), c);
    }

    public static GenericName create(CharSequence[] charSequenceArray) {
        return NameFactory.create(charSequenceArray, ':');
    }

    public static GenericName create(CharSequence[] charSequenceArray, char c) {
        return NameFactory.create(charSequenceArray, charSequenceArray.length, c);
    }

    private static GenericName create(CharSequence[] charSequenceArray, int n, char c) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n == 1) {
            return new LocalName(charSequenceArray[0]);
        }
        return new ScopedName(NameFactory.create(charSequenceArray, n - 1, c), c, charSequenceArray[n - 1]);
    }

    public static GenericName[] toArray(Object object) throws ClassCastException {
        if (object instanceof GenericName[]) {
            return (GenericName[])object;
        }
        if (object instanceof GenericName) {
            return new GenericName[]{(GenericName)object};
        }
        if (object instanceof CharSequence) {
            return new GenericName[]{NameFactory.create(object.toString())};
        }
        if (object instanceof CharSequence[]) {
            CharSequence[] charSequenceArray = (CharSequence[])object;
            GenericName[] genericNameArray = new GenericName[charSequenceArray.length];
            for (int i = 0; i < charSequenceArray.length; ++i) {
                CharSequence charSequence = charSequenceArray[i];
                genericNameArray[i] = charSequence instanceof GenericName ? (GenericName)((Object)charSequence) : NameFactory.create(charSequence.toString());
            }
            return genericNameArray;
        }
        if (object instanceof Identifier[]) {
            Identifier[] identifierArray = (Identifier[])object;
            GenericName[] genericNameArray = new GenericName[identifierArray.length];
            for (int i = 0; i < identifierArray.length; ++i) {
                Identifier identifier = identifierArray[i];
                genericNameArray[i] = identifier instanceof GenericName ? (GenericName)((Object)identifier) : NameFactory.create(identifier.getCode());
            }
            return genericNameArray;
        }
        throw new ClassCastException("Cannot convert " + Classes.getShortClassName(object) + " to GenericName[]");
    }
}

