/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index;

import java.util.ArrayList;
import org.geotools.index.DataDefinition;
import org.geotools.index.TreeException;

public class Data {
    private DataDefinition def;
    private ArrayList values;

    public Data(DataDefinition dataDefinition) {
        this.def = dataDefinition;
        this.values = new ArrayList(dataDefinition.getFieldsCount());
    }

    public Data addValue(Object object) throws TreeException {
        if (this.values.size() == this.def.getFieldsCount()) {
            throw new TreeException("Max number of values reached!");
        }
        int n = this.values.size();
        if (!object.getClass().equals(this.def.getField(n).getFieldClass())) {
            throw new TreeException("Wrong class type, was expecting " + this.def.getField(n).getFieldClass());
        }
        this.values.add(object);
        return this;
    }

    public Object getValue(int n) {
        return this.values.get(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(" - ");
            }
            stringBuffer.append(this.def.getField(i).getFieldClass());
            stringBuffer.append(": ");
            stringBuffer.append(this.values.get(i));
        }
        return stringBuffer.toString();
    }

    public void clear() {
        this.values.clear();
    }
}

