/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class DefaultCoordinateSequenceTransformer
implements CoordinateSequenceTransformer {
    private final transient double[] buffer = new double[96];
    private final CoordinateSequenceFactory csFactory = DefaultCoordinateSequenceFactory.instance();

    @Override
    public CoordinateSequence transform(CoordinateSequence coordinateSequence, MathTransform mathTransform) throws TransformException {
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        int n3 = coordinateSequence.size();
        Coordinate[] coordinateArray = new Coordinate[n3];
        int n4 = this.buffer.length / Math.max(n, n2);
        int n5 = Math.min(n4, n3);
        int n6 = 0;
        int n7 = 0;
        int n8 = n2 + (coordinateSequence.getDimension() - n);
        CoordinateSequence coordinateSequence2 = this.csFactory.create(coordinateSequence.size(), n8);
        for (int i = 0; i < n3; ++i) {
            switch (n) {
                default: {
                    throw new MismatchedDimensionException();
                }
                case 3: {
                    this.buffer[n6 + 2] = coordinateSequence.getOrdinate(i, 2);
                }
                case 2: {
                    this.buffer[n6 + 1] = coordinateSequence.getY(i);
                }
                case 1: {
                    this.buffer[n6] = coordinateSequence.getX(i);
                }
                case 0: 
            }
            n6 += n;
            if (--n5 != 0) continue;
            assert (n6 % n == 0);
            int n9 = n6 / n;
            mathTransform.transform(this.buffer, 0, this.buffer, 0, n9);
            n6 = 0;
            for (int j = 0; j < n9; ++j) {
                int n10;
                for (n10 = 0; n10 < n2; ++n10) {
                    coordinateSequence2.setOrdinate(n7, n10, this.buffer[n6++]);
                }
                while (n10 < n8) {
                    coordinateSequence2.setOrdinate(n7, n10, coordinateSequence.getOrdinate(n7, n10 + (n2 - n)));
                    ++n10;
                }
                while (n10 < coordinateSequence2.getDimension()) {
                    coordinateSequence2.setOrdinate(n7, n10, Double.NaN);
                    ++n10;
                }
                ++n7;
            }
            assert (n6 == n9 * n2);
            n6 = 0;
            n5 = Math.min(n4, n3 - (i + 1));
        }
        assert (n7 == coordinateArray.length) : coordinateArray.length - n7;
        return coordinateSequence2;
    }
}

