/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.HashMap;
import java.util.Map;
import org.geotools.resources.Classes;
import org.geotools.util.Utilities;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;

public class PropertyDescriptorImpl
implements PropertyDescriptor {
    protected final PropertyType type;
    protected final Name name;
    protected final int minOccurs;
    protected final int maxOccurs;
    protected final boolean isNillable;
    final Map<Object, Object> userData;

    protected PropertyDescriptorImpl(PropertyType propertyType, Name name, int n, int n2, boolean bl) {
        this.type = propertyType;
        this.name = name;
        this.minOccurs = n;
        this.maxOccurs = n2;
        this.isNillable = bl;
        this.userData = new HashMap<Object, Object>();
        if (propertyType == null) {
            throw new NullPointerException("type");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (n2 > 0 && n2 < n) {
            throw new IllegalArgumentException("max must be -1, or < min");
        }
    }

    @Override
    public PropertyType getType() {
        return this.type;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public boolean isNillable() {
        return this.isNillable;
    }

    @Override
    public Map<Object, Object> getUserData() {
        return this.userData;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropertyDescriptorImpl)) {
            return false;
        }
        PropertyDescriptorImpl propertyDescriptorImpl = (PropertyDescriptorImpl)object;
        return Utilities.equals(this.type, propertyDescriptorImpl.type) && Utilities.equals(this.name, propertyDescriptorImpl.name) && this.minOccurs == propertyDescriptorImpl.minOccurs && this.maxOccurs == propertyDescriptorImpl.maxOccurs && this.isNillable == propertyDescriptorImpl.isNillable;
    }

    public int hashCode() {
        return 37 * this.minOccurs + 37 * this.maxOccurs ^ this.type.hashCode() ^ this.name.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(Classes.getShortClassName(this));
        stringBuffer.append(" ");
        stringBuffer.append(this.getName());
        if (this.type != null) {
            stringBuffer.append(" <");
            stringBuffer.append(this.type.getName().getLocalPart());
            stringBuffer.append(":");
            stringBuffer.append(Classes.getShortName(this.type.getBinding()));
            stringBuffer.append(">");
        }
        if (this.isNillable) {
            stringBuffer.append(" nillable");
        }
        if (this.minOccurs != 1 || this.maxOccurs != 1) {
            stringBuffer.append(" ");
            stringBuffer.append(this.minOccurs);
            stringBuffer.append(":");
            stringBuffer.append(this.maxOccurs);
        }
        if (this.userData != null && !this.userData.isEmpty()) {
            stringBuffer.append("\nuserData=(");
            for (Map.Entry<Object, Object> entry : this.userData.entrySet()) {
                stringBuffer.append("\n\t");
                stringBuffer.append(entry.getKey());
                stringBuffer.append(" ==> ");
                stringBuffer.append(entry.getValue());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

