/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.resources.NIOUtilities;
import org.geotools.util.logging.Logging;

public class ShapefileReader
implements FileReader {
    private static final Logger LOGGER = Logging.getLogger(ShapefileReader.class);
    private static final int UNKNOWN = Integer.MIN_VALUE;
    private ShapeHandler handler;
    private ShapefileHeader header;
    private ReadableByteChannel channel;
    ByteBuffer buffer;
    private ShapeType fileShapeType = ShapeType.UNDEFINED;
    private ByteBuffer headerTransfer;
    private final Record record = new Record();
    private final boolean randomAccessEnabled;
    private boolean useMemoryMappedBuffer;
    private long currentOffset = 0L;
    private int currentShape = 0;
    private IndexFile shxReader;
    private StreamLogging streamLogger = new StreamLogging("Shapefile Reader");
    private boolean flatGeometry;

    public ShapefileReader(ShpFiles shpFiles, boolean bl, boolean bl2, GeometryFactory geometryFactory) throws IOException, ShapefileException {
        this.channel = shpFiles.getReadChannel(ShpFileType.SHP, this);
        this.useMemoryMappedBuffer = bl2;
        this.streamLogger.open();
        this.randomAccessEnabled = this.channel instanceof FileChannel;
        try {
            this.shxReader = new IndexFile(shpFiles, this.useMemoryMappedBuffer);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Could not open the .shx file, continuing assuming the .shp file is not sparse", exception);
            this.currentShape = Integer.MIN_VALUE;
        }
        this.init(bl, geometryFactory);
    }

    public ShapefileReader(ShpFiles shpFiles, boolean bl, boolean bl2, GeometryFactory geometryFactory, boolean bl3) throws IOException, ShapefileException {
        this.channel = shpFiles.getReadChannel(ShpFileType.SHP, this);
        this.useMemoryMappedBuffer = bl2;
        this.streamLogger.open();
        this.randomAccessEnabled = this.channel instanceof FileChannel;
        if (!bl3) {
            try {
                this.shxReader = new IndexFile(shpFiles, this.useMemoryMappedBuffer);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Could not open the .shx file, continuing assuming the .shp file is not sparse", exception);
                this.currentShape = Integer.MIN_VALUE;
            }
        }
        this.init(bl, geometryFactory);
    }

    public void disableShxUsage() throws IOException {
        if (this.shxReader != null) {
            this.shxReader.close();
            this.shxReader = null;
        }
        this.currentShape = Integer.MIN_VALUE;
    }

    private ByteBuffer ensureCapacity(ByteBuffer byteBuffer, int n, boolean bl) {
        int n2;
        if (byteBuffer.isReadOnly() || bl) {
            return byteBuffer;
        }
        for (n2 = byteBuffer.limit(); n2 < n; n2 *= 2) {
        }
        if (n2 != byteBuffer.limit()) {
            byteBuffer = NIOUtilities.allocate(n2);
        }
        return byteBuffer;
    }

    public static int fill(ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel) throws IOException {
        int n = byteBuffer.remaining();
        while (byteBuffer.remaining() > 0 && n != -1) {
            n = readableByteChannel.read(byteBuffer);
        }
        byteBuffer.limit(byteBuffer.position());
        return n;
    }

    private void init(boolean bl, GeometryFactory geometryFactory) throws IOException, ShapefileException {
        if (this.channel instanceof FileChannel && this.useMemoryMappedBuffer) {
            FileChannel fileChannel = (FileChannel)this.channel;
            this.buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            this.buffer.position(0);
            this.currentOffset = 0L;
        } else {
            this.useMemoryMappedBuffer = false;
            this.buffer = NIOUtilities.allocate(1024);
            ShapefileReader.fill(this.buffer, this.channel);
            this.buffer.flip();
            this.currentOffset = 0L;
        }
        this.header = new ShapefileHeader();
        this.header.read(this.buffer, bl);
        this.fileShapeType = this.header.getShapeType();
        this.handler = this.fileShapeType.getShapeHandler(geometryFactory);
        if (this.handler == null) {
            throw new IOException("Unsuported shape type:" + this.fileShapeType);
        }
        this.headerTransfer = ByteBuffer.allocate(8);
        this.headerTransfer.order(ByteOrder.BIG_ENDIAN);
        this.record.end = this.toFileOffset(this.buffer.position());
    }

    public ShapefileHeader getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.channel == null) {
            return;
        }
        try {
            if (this.channel.isOpen()) {
                this.channel.close();
                this.streamLogger.close();
            }
            NIOUtilities.clean(this.buffer, this.useMemoryMappedBuffer);
        }
        finally {
            if (this.shxReader != null) {
                this.shxReader.close();
            }
        }
        this.shxReader = null;
        this.channel = null;
        this.header = null;
    }

    public boolean hasNext() throws IOException {
        return this.hasNext(true);
    }

    private boolean hasNext(boolean bl) throws IOException {
        if (this.currentShape > Integer.MIN_VALUE && this.currentShape > this.shxReader.getRecordCount() - 1) {
            return false;
        }
        int n = this.buffer.position();
        this.buffer.position(this.getNextOffset());
        if (this.buffer.remaining() < 8) {
            return false;
        }
        boolean bl2 = true;
        if (bl) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
            int n2 = this.buffer.getInt();
            bl2 = n2 == this.record.number + 1;
        }
        this.buffer.position(n);
        return bl2;
    }

    private int getNextOffset() throws IOException {
        if (this.currentShape >= 0) {
            return this.toBufferOffset(this.shxReader.getOffsetInBytes(this.currentShape));
        }
        return this.toBufferOffset(this.record.end);
    }

    public Record nextRecord() throws IOException {
        Object object;
        this.buffer.position(this.getNextOffset());
        if (this.currentShape != Integer.MIN_VALUE) {
            ++this.currentShape;
        }
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int n = this.buffer.getInt();
        int n2 = this.buffer.getInt() * 2;
        if (!this.buffer.isReadOnly() && !this.useMemoryMappedBuffer) {
            if (this.buffer.capacity() < n2 + 8) {
                this.currentOffset += (long)this.buffer.position();
                object = this.buffer;
                this.buffer = this.ensureCapacity(this.buffer, n2 + 8, this.useMemoryMappedBuffer);
                this.buffer.put((ByteBuffer)object);
                NIOUtilities.clean((ByteBuffer)object, this.useMemoryMappedBuffer);
                ShapefileReader.fill(this.buffer, this.channel);
                this.buffer.position(0);
            } else if (this.buffer.remaining() < n2 + 8) {
                this.currentOffset += (long)this.buffer.position();
                this.buffer.compact();
                ShapefileReader.fill(this.buffer, this.channel);
                this.buffer.position(0);
            }
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        object = ShapeType.forID(this.buffer.getInt());
        if (object != ShapeType.NULL && object != this.fileShapeType) {
            throw new IllegalStateException("ShapeType changed illegally from " + this.fileShapeType + " to " + object);
        }
        this.buffer.mark();
        if (((ShapeType)object).isMultiPoint()) {
            this.record.minX = this.buffer.getDouble();
            this.record.minY = this.buffer.getDouble();
            this.record.maxX = this.buffer.getDouble();
            this.record.maxY = this.buffer.getDouble();
        } else if (object != ShapeType.NULL) {
            this.record.minX = this.record.maxX = this.buffer.getDouble();
            this.record.minY = this.record.maxY = this.buffer.getDouble();
        }
        this.buffer.reset();
        this.record.length = n2;
        this.record.type = object;
        this.record.number = n;
        this.record.end = this.toFileOffset(this.buffer.position()) + n2 - 4;
        this.record.start = this.buffer.position();
        this.record.shape = null;
        return this.record;
    }

    public void goTo(int n) throws IOException, UnsupportedOperationException {
        this.disableShxUsage();
        if (this.randomAccessEnabled) {
            if (this.useMemoryMappedBuffer) {
                this.buffer.position(n);
            } else if (this.currentOffset <= (long)n && this.currentOffset + (long)this.buffer.limit() >= (long)(n + 8)) {
                this.buffer.position(this.toBufferOffset(n));
            } else {
                FileChannel fileChannel = (FileChannel)this.channel;
                fileChannel.position(n);
                this.currentOffset = n;
                this.buffer.position(0);
                this.buffer.limit(this.buffer.capacity());
                ShapefileReader.fill(this.buffer, fileChannel);
                this.buffer.position(0);
            }
            int n2 = this.record.end;
            this.record.end = n;
            try {
                this.hasNext(false);
            }
            catch (IOException iOException) {
                this.record.end = n2;
                throw iOException;
            }
        } else {
            throw new UnsupportedOperationException("Random Access not enabled");
        }
    }

    private int toBufferOffset(int n) {
        return (int)((long)n - this.currentOffset);
    }

    private int toFileOffset(int n) {
        return (int)(this.currentOffset + (long)n);
    }

    public int getCount(int n) throws DataSourceException {
        try {
            if (this.channel == null) {
                return -1;
            }
            n = 0;
            long l = this.currentOffset;
            try {
                this.goTo(100);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return -1;
            }
            while (this.hasNext()) {
                ++n;
                this.nextRecord();
            }
            this.goTo((int)l);
        }
        catch (IOException iOException) {
            n = -1;
            throw new DataSourceException("Problem reading shapefile record", iOException);
        }
        return n;
    }

    public void setFlatGeometry(boolean bl) {
        this.flatGeometry = bl;
    }

    public final class Record {
        int length;
        public int number = 0;
        int start = 0;
        public double minX;
        public double minY;
        public double maxX;
        public double maxY;
        public ShapeType type;
        int end = 0;
        Object shape = null;

        public Object shape() {
            if (this.shape == null) {
                ShapefileReader.this.buffer.position(this.start);
                ShapefileReader.this.buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.shape = this.type == ShapeType.NULL ? null : ShapefileReader.this.handler.read(ShapefileReader.this.buffer, this.type, ShapefileReader.this.flatGeometry);
            }
            return this.shape;
        }

        public String toString() {
            return "Record " + this.number + " length " + this.length + " bounds " + this.minX + "," + this.minY + " " + this.maxX + "," + this.maxY;
        }

        public Envelope envelope() {
            return new Envelope(this.minX, this.maxX, this.minY, this.maxY);
        }
    }
}

