/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.GeometryFactory;
import org.geotools.data.shapefile.shp.MultiLineHandler;
import org.geotools.data.shapefile.shp.MultiPointHandler;
import org.geotools.data.shapefile.shp.PointHandler;
import org.geotools.data.shapefile.shp.PolygonHandler;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapefileException;

public final class ShapeType {
    public static final ShapeType NULL = new ShapeType(0, "Null");
    public static final ShapeType POINT = new ShapeType(1, "Point");
    public static final ShapeType POINTZ = new ShapeType(11, "PointZ");
    public static final ShapeType POINTM = new ShapeType(21, "PointM");
    public static final ShapeType ARC = new ShapeType(3, "Arc");
    public static final ShapeType ARCZ = new ShapeType(13, "ArcZ");
    public static final ShapeType ARCM = new ShapeType(23, "ArcM");
    public static final ShapeType POLYGON = new ShapeType(5, "Polygon");
    public static final ShapeType POLYGONZ = new ShapeType(15, "PolygonZ");
    public static final ShapeType POLYGONM = new ShapeType(25, "PolygonM");
    public static final ShapeType MULTIPOINT = new ShapeType(8, "MultiPoint");
    public static final ShapeType MULTIPOINTZ = new ShapeType(18, "MultiPointZ");
    public static final ShapeType MULTIPOINTM = new ShapeType(28, "MultiPointM");
    public static final ShapeType UNDEFINED = new ShapeType(-1, "Undefined");
    public final int id;
    public final String name;

    protected ShapeType(int n, String string) {
        this.id = n;
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public boolean isMultiPoint() {
        boolean bl = true;
        if (this == UNDEFINED) {
            bl = false;
        } else if (this == NULL) {
            bl = false;
        } else if (this == POINT || this == POINTM || this == POINTZ) {
            bl = false;
        }
        return bl;
    }

    public boolean isPointType() {
        return this.id % 10 == 1;
    }

    public boolean isLineType() {
        return this.id % 10 == 3;
    }

    public boolean isPolygonType() {
        return this.id % 10 == 5;
    }

    public boolean isMultiPointType() {
        return this.id % 10 == 8;
    }

    public static ShapeType forID(int n) {
        ShapeType shapeType;
        switch (n) {
            case 0: {
                shapeType = NULL;
                break;
            }
            case 1: {
                shapeType = POINT;
                break;
            }
            case 11: {
                shapeType = POINTZ;
                break;
            }
            case 21: {
                shapeType = POINTM;
                break;
            }
            case 3: {
                shapeType = ARC;
                break;
            }
            case 13: {
                shapeType = ARCZ;
                break;
            }
            case 23: {
                shapeType = ARCM;
                break;
            }
            case 5: {
                shapeType = POLYGON;
                break;
            }
            case 15: {
                shapeType = POLYGONZ;
                break;
            }
            case 25: {
                shapeType = POLYGONM;
                break;
            }
            case 8: {
                shapeType = MULTIPOINT;
                break;
            }
            case 18: {
                shapeType = MULTIPOINTZ;
                break;
            }
            case 28: {
                shapeType = MULTIPOINTM;
                break;
            }
            default: {
                shapeType = UNDEFINED;
            }
        }
        return shapeType;
    }

    public ShapeHandler getShapeHandler(GeometryFactory geometryFactory) throws ShapefileException {
        ShapeHandler shapeHandler;
        switch (this.id) {
            case 1: 
            case 11: 
            case 21: {
                shapeHandler = new PointHandler(this, geometryFactory);
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                shapeHandler = new MultiLineHandler(this, geometryFactory);
                break;
            }
            case 5: 
            case 15: 
            case 25: {
                shapeHandler = new PolygonHandler(this, geometryFactory);
                break;
            }
            case 8: 
            case 18: 
            case 28: {
                shapeHandler = new MultiPointHandler(this, geometryFactory);
                break;
            }
            default: {
                shapeHandler = null;
            }
        }
        return shapeHandler;
    }
}

