/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class PointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;

    public PointHandler(ShapeType shapeType, GeometryFactory geometryFactory) throws ShapefileException {
        if (shapeType != ShapeType.POINT && shapeType != ShapeType.POINTM && shapeType != ShapeType.POINTZ) {
            throw new ShapefileException("PointHandler constructor: expected a type of 1, 11 or 21");
        }
        this.shapeType = shapeType;
        this.geometryFactory = geometryFactory;
    }

    public PointHandler() {
        this.shapeType = ShapeType.POINT;
    }

    @Override
    public Object read(ByteBuffer byteBuffer, ShapeType shapeType, boolean bl) {
        if (shapeType == ShapeType.NULL) {
            return this.createNull();
        }
        int n = this.shapeType == ShapeType.POINTZ && !bl ? 3 : 2;
        CoordinateSequence coordinateSequence = this.geometryFactory.getCoordinateSequenceFactory().create(1, n);
        coordinateSequence.setOrdinate(0, 0, byteBuffer.getDouble());
        coordinateSequence.setOrdinate(0, 1, byteBuffer.getDouble());
        if (this.shapeType == ShapeType.POINTM) {
            byteBuffer.getDouble();
        }
        if (n > 2) {
            coordinateSequence.setOrdinate(0, 2, byteBuffer.getDouble());
        }
        return this.geometryFactory.createPoint(coordinateSequence);
    }

    private Object createNull() {
        return this.geometryFactory.createPoint(new Coordinate(Double.NaN, Double.NaN, Double.NaN));
    }
}

