/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FIDFeatureReader;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShapefileAttributeReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.indexed.CloseableIteratorWrapper;
import org.geotools.data.shapefile.indexed.IndexType;
import org.geotools.data.shapefile.indexed.IndexedFidReader;
import org.geotools.data.shapefile.indexed.IndexedShapefileAttributeReader;
import org.geotools.data.shapefile.indexed.ShapeFIDReader;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.factory.Hints;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.IdCollectorFilterVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.index.CachedQuadTree;
import org.geotools.index.CloseableIterator;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;
import org.geotools.index.TreeException;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemIndexStore;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;

public class IndexedShapefileDataStore
extends ShapefileDataStore
implements FileReader {
    IndexType treeType;
    final boolean useIndex;
    final boolean createIndex;
    CachedQuadTree cachedTree;
    int maxQixCacheSize = DEFAULT_MAX_QIX_CACHE_SIZE;
    static final int DEFAULT_MAX_QIX_CACHE_SIZE;

    public IndexedShapefileDataStore(URL uRL, URI uRI, boolean bl, boolean bl2, boolean bl3, IndexType indexType, Charset charset) {
        super(uRL, uRI, bl, bl2, charset);
        this.treeType = indexType;
        this.useIndex = indexType != IndexType.NONE;
        this.createIndex = bl3;
    }

    @Override
    protected Filter getUnsupportedFilter(String string, Filter filter) {
        if (filter instanceof Id && this.isLocal() && this.shpFiles.exists(ShpFileType.FIX)) {
            return Filter.INCLUDE;
        }
        return filter;
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String string, Transaction transaction) throws IOException {
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        if (transaction == Transaction.AUTO_COMMIT) {
            return super.getFeatureWriterAppend(string, transaction);
        }
        FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter = this.state(transaction).writer(string, Filter.EXCLUDE);
        if (this.getLockingManager() != null) {
            featureWriter = ((InProcessLockingManager)this.getLockingManager()).checkedWriter(featureWriter, transaction);
        }
        while (featureWriter.hasNext()) {
            featureWriter.next();
        }
        return featureWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TransactionStateDiff state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            TransactionStateDiff transactionStateDiff = (TransactionStateDiff)transaction.getState(this);
            if (transactionStateDiff == null) {
                transactionStateDiff = new TransactionStateDiff(this);
                transaction.putState(this, transactionStateDiff);
            }
            return transactionStateDiff;
        }
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String string, Query query) throws IOException {
        Object object;
        if (query.getFilter() == Filter.EXCLUDE) {
            return new EmptyFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema());
        }
        String[] stringArray = query.getPropertyNames() == null ? new String[]{} : query.getPropertyNames();
        String string2 = this.schema.getGeometryDescriptor().getLocalName();
        if (stringArray.length > 0) {
            object = new FilterAttributeExtractor(this.schema);
            query.getFilter().accept((FilterVisitor)object, null);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
            linkedHashSet.addAll(((FilterAttributeExtractor)object).getAttributeNameSet());
            stringArray = linkedHashSet.toArray(new String[linkedHashSet.size()]);
        }
        object = this.schema;
        boolean bl = true;
        boolean bl2 = true;
        try {
            if (query.getPropertyNames() != Query.NO_NAMES && stringArray.length == 1 && stringArray[0].equals(string2)) {
                bl = false;
                object = this.createSubType(stringArray);
            } else if (query.getPropertyNames() == Query.NO_NAMES && stringArray.length == 0) {
                bl = false;
                bl2 = false;
                object = this.createSubType(stringArray);
            } else if (stringArray.length > 0 && !stringArray[0].equals(string2)) {
                bl2 = false;
                object = this.createSubType(stringArray);
            } else if (stringArray.length > 0) {
                object = this.createSubType(stringArray);
            }
            return this.createFeatureReader(string, this.getAttributesReader(bl, bl2, query, (SimpleFeatureType)object), (SimpleFeatureType)object);
        }
        catch (SchemaException schemaException) {
            throw new DataSourceException("Error creating schema", schemaException);
        }
    }

    public SimpleFeatureType createSubType(String[] stringArray) throws SchemaException {
        if (stringArray == null || stringArray.length == 0) {
            return this.schema;
        }
        boolean bl = this.schema.getAttributeCount() == stringArray.length;
        for (int i = 0; i < this.schema.getAttributeCount() && bl; ++i) {
            bl = this.schema.getDescriptor(i).getLocalName().equals(stringArray[i]);
        }
        if (bl) {
            return this.schema;
        }
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(this.schema.getName());
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        for (AttributeDescriptor attributeDescriptor : this.schema.getAttributeDescriptors()) {
            if (!hashSet.contains(attributeDescriptor.getLocalName())) continue;
            simpleFeatureTypeBuilder.add(attributeDescriptor);
        }
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> createFeatureReader(String string, IndexedShapefileAttributeReader indexedShapefileAttributeReader, SimpleFeatureType simpleFeatureType) throws SchemaException, IOException {
        if (indexedShapefileAttributeReader == null) {
            return new EmptyFeatureReader<SimpleFeatureType, SimpleFeature>(simpleFeatureType);
        }
        FIDReader fIDReader = !this.indexUseable(ShpFileType.FIX) ? new ShapeFIDReader(this.getCurrentTypeName(), (ShapefileAttributeReader)indexedShapefileAttributeReader) : new IndexedFidReader(this.shpFiles, indexedShapefileAttributeReader);
        return new FIDFeatureReader(indexedShapefileAttributeReader, fIDReader, simpleFeatureType);
    }

    protected IndexedShapefileAttributeReader getAttributesReader(boolean bl, boolean bl2, Query query, SimpleFeatureType simpleFeatureType) throws IOException {
        Object object;
        Object object2;
        ArrayList<AttributeDescriptor> arrayList;
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope();
        Filter filter = query != null ? query.getFilter() : null;
        CloseableIterator<Data> closeableIterator = null;
        if (filter instanceof Id && this.shpFiles.isLocal() && this.indexUseable(ShpFileType.FIX)) {
            arrayList = (Id)filter;
            object2 = new TreeSet<Identifier>(new IdentifierComparator());
            ((TreeSet)object2).addAll(arrayList.getIdentifiers());
            object = this.queryFidIndex((Set<Identifier>)object2);
            if (object != null) {
                closeableIterator = new CloseableIteratorWrapper<Data>(object.iterator());
            }
        } else {
            if (filter != null && (referencedEnvelope = (Envelope)filter.accept(ExtractBoundsFilterVisitor.BOUNDS_VISITOR, referencedEnvelope)) == null) {
                referencedEnvelope = new ReferencedEnvelope();
            }
            if (!referencedEnvelope.isNull() && this.useIndex) {
                try {
                    closeableIterator = this.queryQuadTree(referencedEnvelope);
                }
                catch (TreeException treeException) {
                    throw new IOException("Error querying index: " + treeException.getMessage());
                }
            }
        }
        arrayList = simpleFeatureType.getAttributeDescriptors();
        object2 = null;
        if (closeableIterator != null && !closeableIterator.hasNext()) {
            closeableIterator.close();
            return null;
        }
        if (!bl) {
            LOGGER.fine("The DBF file won't be opened since no attributes will be read from it");
            arrayList = new ArrayList<AttributeDescriptor>(1);
            arrayList.add(this.schema.getGeometryDescriptor());
            if (!bl2) {
                arrayList = new ArrayList(1);
            }
        } else {
            object2 = (IndexedDbaseFileReader)this.openDbfReader();
        }
        object = query != null ? query.getHints() : null;
        ShapefileReader shapefileReader = this.openShapeReader(this.getGeometryFactory((Hints)object), closeableIterator != null);
        IndexedShapefileAttributeReader indexedShapefileAttributeReader = new IndexedShapefileAttributeReader(arrayList, shapefileReader, (IndexedDbaseFileReader)object2, closeableIterator);
        indexedShapefileAttributeReader.setTargetBBox(referencedEnvelope);
        if (object != null) {
            Number number = (Number)((RenderingHints)object).get(Hints.GEOMETRY_DISTANCE);
            if (number != null) {
                indexedShapefileAttributeReader.setSimplificationDistance(number.doubleValue());
            }
            if (Boolean.TRUE.equals(((RenderingHints)object).get(Hints.FEATURE_2D))) {
                shapefileReader.setFlatGeometry(true);
            }
        }
        return indexedShapefileAttributeReader;
    }

    protected ShapefileReader openShapeReader(GeometryFactory geometryFactory, boolean bl) throws IOException {
        try {
            return new ShapefileReader(this.shpFiles, true, this.useMemoryMappedBuffer, geometryFactory, bl);
        }
        catch (ShapefileException shapefileException) {
            throw new DataSourceException("Error creating ShapefileReader", shapefileException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Data> queryFidIndex(Set<Identifier> set) throws IOException {
        if (!this.indexUseable(ShpFileType.FIX)) {
            return null;
        }
        IndexedFidReader indexedFidReader = new IndexedFidReader(this.shpFiles);
        ArrayList<Data> arrayList = new ArrayList<Data>(set.size());
        try {
            IndexFile indexFile = this.openIndexFile();
            try {
                DataDefinition dataDefinition = new DataDefinition("US-ASCII");
                dataDefinition.addField(Integer.class);
                dataDefinition.addField(Long.class);
                for (Identifier identifier : set) {
                    String string = identifier.toString();
                    long l = indexedFidReader.findFid(string);
                    if (l == -1L) {
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.finest("fid " + string + " not found in index, continuing with next queried fid...");
                        continue;
                    }
                    try {
                        Data data = new Data(dataDefinition);
                        data.addValue(new Integer((int)l + 1));
                        data.addValue(new Long(indexFile.getOffsetInBytes((int)l)));
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("fid " + string + " found for record #" + data.getValue(0) + " at index file offset " + data.getValue(1));
                        }
                        arrayList.add(data);
                    }
                    catch (Exception exception) {
                        IOException iOException = new IOException();
                        iOException.initCause(exception);
                        throw iOException;
                        return arrayList;
                    }
                }
            }
            finally {
                indexFile.close();
            }
        }
        finally {
            indexedFidReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexUseable(ShpFileType shpFileType) {
        if (this.isLocal()) {
            if (this.needsGeneration(shpFileType) || !this.shpFiles.exists(shpFileType)) {
                return false;
            }
        } else {
            ReadableByteChannel readableByteChannel = null;
            try {
                readableByteChannel = this.shpFiles.getReadChannel(shpFileType, this);
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (readableByteChannel != null) {
                    try {
                        readableByteChannel.close();
                    }
                    catch (IOException iOException) {
                        ShapefileDataStoreFactory.LOGGER.log(Level.WARNING, "could not close stream", iOException);
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needsGeneration(ShpFileType shpFileType) {
        if (shpFileType == null) {
            return false;
        }
        if (!this.isLocal()) {
            throw new IllegalStateException("This method only applies if the files are local and the file can be created");
        }
        URL uRL = this.shpFiles.acquireRead(shpFileType, this);
        URL uRL2 = this.shpFiles.acquireRead(ShpFileType.SHP, this);
        try {
            long l;
            if (uRL == null) {
                boolean bl = true;
                return bl;
            }
            if (!this.shpFiles.exists(ShpFileType.SHX) || !this.shpFiles.exists(ShpFileType.SHP)) {
                boolean bl = false;
                return bl;
            }
            File file = DataUtilities.urlToFile(uRL);
            File file2 = DataUtilities.urlToFile(uRL2);
            long l2 = file.lastModified();
            boolean bl = l2 < (l = file2.lastModified());
            boolean bl2 = !file.exists() || bl;
            return bl2;
        }
        finally {
            if (uRL2 != null) {
                this.shpFiles.unlockRead(uRL2, this);
            }
            if (uRL != null) {
                this.shpFiles.unlockRead(uRL, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableIterator<Data> queryQuadTree(Envelope envelope) throws DataSourceException, IOException, TreeException {
        CloseableIterator<Data> closeableIterator = null;
        if (this.cachedTree == null) {
            Object object;
            boolean bl = false;
            URL uRL = this.shpFiles.acquireRead(ShpFileType.QIX, this);
            try {
                object = DataUtilities.urlToFile(uRL);
                if (((File)object).exists() && ((File)object).length() < (long)(1024 * this.maxQixCacheSize)) {
                    bl = true;
                }
            }
            finally {
                this.shpFiles.unlockRead(uRL, this);
            }
            if (bl && (object = this.openQuadTree()) != null) {
                LOGGER.warning("Experimental: loading in memory the quadtree for " + this.shpFiles.get(ShpFileType.SHP));
                this.cachedTree = new CachedQuadTree((QuadTree)object);
                ((QuadTree)object).close();
            }
        }
        if (this.cachedTree != null) {
            if (!envelope.contains(this.cachedTree.getBounds())) {
                return this.cachedTree.search(envelope);
            }
            return null;
        }
        try {
            QuadTree quadTree = this.openQuadTree();
            if (quadTree != null && !envelope.contains(quadTree.getRoot().getBounds())) {
                closeableIterator = quadTree.search(envelope);
            }
            if (closeableIterator == null && quadTree != null) {
                quadTree.close();
            }
        }
        catch (Exception exception) {
            throw new DataSourceException("Error querying QuadTree", exception);
        }
        return closeableIterator;
    }

    @Override
    protected DbaseFileReader openDbfReader() throws IOException {
        if (this.shpFiles.get(ShpFileType.DBF) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.DBF)) {
            return null;
        }
        return new IndexedDbaseFileReader(this.shpFiles, this.useMemoryMappedBuffer, this.dbfCharset, this.dbfTimeZone);
    }

    protected QuadTree openQuadTree() throws StoreException {
        if (!this.isLocal()) {
            return null;
        }
        URL uRL = this.shpFiles.acquireRead(ShpFileType.QIX, this);
        try {
            File file = DataUtilities.urlToFile(uRL);
            if (!file.exists() || file.length() == 0L) {
                this.treeType = IndexType.NONE;
                QuadTree quadTree = null;
                return quadTree;
            }
            FileSystemIndexStore fileSystemIndexStore = new FileSystemIndexStore(file);
            QuadTree quadTree = fileSystemIndexStore.load(this.openIndexFile(), this.useMemoryMappedBuffer);
            return quadTree;
        }
        finally {
            this.shpFiles.unlockRead(uRL, this);
        }
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String string, Transaction transaction) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        Object object;
        Object object2;
        ReferencedEnvelope referencedEnvelope = null;
        HashSet hashSet = new HashSet();
        Filter filter = query.getFilter();
        if (filter == Filter.INCLUDE || query == Query.ALL) {
            return this.getBounds();
        }
        IdentifierComparator identifierComparator = new IdentifierComparator();
        Set set = (Set)filter.accept(IdCollectorFilterVisitor.IDENTIFIER_COLLECTOR, new TreeSet<Identifier>(identifierComparator));
        if (!set.isEmpty() && (object2 = this.queryFidIndex(set)) != null) {
            hashSet.addAll(object2);
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        object2 = query.getHints();
        GeometryFactory geometryFactory = (GeometryFactory)((RenderingHints)object2).get(Hints.JTS_GEOMETRY_FACTORY);
        if (geometryFactory == null && (object = (CoordinateSequenceFactory)((RenderingHints)object2).get(Hints.JTS_COORDINATE_SEQUENCE_FACTORY)) != null) {
            geometryFactory = new GeometryFactory((CoordinateSequenceFactory)object);
        }
        if (geometryFactory == null) {
            geometryFactory = new GeometryFactory();
        }
        object = new ShapefileReader(this.shpFiles, false, false, geometryFactory);
        try {
            referencedEnvelope = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
            for (Data data : hashSet) {
                ((ShapefileReader)object).goTo(((Long)data.getValue(1)).intValue());
                ShapefileReader.Record record = ((ShapefileReader)object).nextRecord();
                referencedEnvelope.expandToInclude(new Envelope(record.minX, record.maxX, record.minY, record.maxY));
            }
            ReferencedEnvelope referencedEnvelope2 = referencedEnvelope;
            return referencedEnvelope2;
        }
        finally {
            ((ShapefileReader)object).close();
        }
    }

    public String id() {
        return this.getClass().getName() + ": " + this.getCurrentTypeName();
    }

    @Override
    protected Set getSupportedHints() {
        HashSet<Hints.Key> hashSet = new HashSet<Hints.Key>();
        hashSet.add(Hints.FEATURE_DETACHED);
        hashSet.add(Hints.JTS_GEOMETRY_FACTORY);
        hashSet.add(Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
        hashSet.add(Hints.GEOMETRY_DISTANCE);
        return hashSet;
    }

    static {
        int n = -1;
        try {
            String string = System.getProperty("org.geotools.shapefile.maxQixCacheSize");
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, "Could not set the max qix cache size", throwable);
        }
        DEFAULT_MAX_QIX_CACHE_SIZE = n;
    }

    private static final class IdentifierComparator
    implements Comparator<Identifier> {
        private IdentifierComparator() {
        }

        @Override
        public int compare(Identifier identifier, Identifier identifier2) {
            return identifier.toString().compareTo(identifier2.toString());
        }
    }
}

