/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FIDFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShapefileAttributeReader;
import org.geotools.data.shapefile.ShapefileFeatureLocking;
import org.geotools.data.shapefile.ShapefileFeatureSource;
import org.geotools.data.shapefile.ShapefileFeatureStore;
import org.geotools.data.shapefile.ShapefileFileServiceInfo;
import org.geotools.data.shapefile.ShapefileURLServiceInfo;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.indexed.ShapeFIDReader;
import org.geotools.data.shapefile.prj.PrjFileReader;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.xml.Metadata;
import org.geotools.data.shapefile.shp.xml.ShpXmlFileReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.resources.Classes;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileDataStore
extends AbstractFileDataStore {
    public static final String ORIGINAL_FIELD_NAME = "original";
    public static final String ORIGINAL_FIELD_DUPLICITY_COUNT = "count";
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.shapefile.trace"));
    protected ShpFiles shpFiles;
    protected URI namespace = null;
    protected SimpleFeatureType schema;
    protected boolean useMemoryMappedBuffer = false;
    protected Charset dbfCharset;
    protected TimeZone dbfTimeZone = TimeZone.getDefault();
    private ServiceInfo info;
    Exception trace;

    public ShapefileDataStore(URL uRL, URI uRI, boolean bl, boolean bl2, Charset charset) {
        this.namespace = uRI;
        this.shpFiles = new ShpFiles(uRL);
        this.useMemoryMappedBuffer = !this.isLocal() || !this.shpFiles.exists(ShpFileType.SHP) ? false : bl;
        this.shpFiles.setMemoryMapCacheEnabled(this.useMemoryMappedBuffer && bl2);
        this.dbfCharset = charset;
        if (TRACE_ENABLED.booleanValue()) {
            this.trace = new Exception();
            this.trace.fillInStackTrace();
        }
    }

    @Override
    public synchronized ServiceInfo getInfo() {
        if (this.info == null) {
            this.info = this.isLocal() ? new ShapefileFileServiceInfo(this) : new ShapefileURLServiceInfo(this);
        }
        return this.info;
    }

    public void setDbftimeZone(TimeZone timeZone) {
        this.dbfTimeZone = timeZone;
    }

    @Override
    protected Map createMetadata(String string) {
        String string2 = this.shpFiles.get(ShpFileType.SHP_XML);
        if (string2 == null) {
            return Collections.EMPTY_MAP;
        }
        try {
            ShpXmlFileReader shpXmlFileReader = new ShpXmlFileReader(this.shpFiles);
            HashMap<String, Metadata> hashMap = new HashMap<String, Metadata>();
            hashMap.put("shp.xml", shpXmlFileReader.parse());
            return hashMap;
        }
        catch (Throwable throwable) {
            LOGGER.warning("Could not parse " + string2 + ":" + throwable.getLocalizedMessage());
            return Collections.EMPTY_MAP;
        }
    }

    public boolean isLocal() {
        return this.shpFiles.isLocal();
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String string) throws IOException {
        this.typeCheck(string);
        return this.getFeatureReader();
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader() throws IOException {
        try {
            return this.createFeatureReader(this.getSchema().getTypeName(), this.getAttributesReader(true, null), this.schema);
        }
        catch (SchemaException schemaException) {
            throw new DataSourceException("Error creating schema", schemaException);
        }
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String string, Query query) throws IOException {
        String[] stringArray = query.getPropertyNames();
        String string2 = this.schema.getGeometryDescriptor().getLocalName();
        FilterAttributeExtractor filterAttributeExtractor = new FilterAttributeExtractor(this.schema);
        Filter filter = query.getFilter();
        filter.accept(filterAttributeExtractor, null);
        String[] stringArray2 = filterAttributeExtractor.getAttributeNames();
        if (stringArray != null && stringArray.length == 1 && stringArray[0].equals(string2) && (stringArray2.length == 0 || stringArray2.length == 1 && stringArray2[0].equals(string2))) {
            try {
                SimpleFeatureType simpleFeatureType = DataUtilities.createSubType(this.schema, stringArray);
                return this.createFeatureReader(string, this.getAttributesReader(false, query), simpleFeatureType);
            }
            catch (SchemaException schemaException) {
                throw new DataSourceException("Error creating schema", schemaException);
            }
        }
        try {
            return this.createFeatureReader(this.getSchema().getTypeName(), this.getAttributesReader(true, query), this.schema);
        }
        catch (SchemaException schemaException) {
            throw new DataSourceException("Error creating schema", schemaException);
        }
    }

    protected GeometryFactory getGeometryFactory(Hints hints) {
        CoordinateSequenceFactory coordinateSequenceFactory;
        if (hints == null) {
            return new GeometryFactory();
        }
        GeometryFactory geometryFactory = (GeometryFactory)hints.get(Hints.JTS_GEOMETRY_FACTORY);
        if (geometryFactory == null && (coordinateSequenceFactory = (CoordinateSequenceFactory)hints.get(Hints.JTS_COORDINATE_SEQUENCE_FACTORY)) != null) {
            geometryFactory = new GeometryFactory(coordinateSequenceFactory);
        }
        if (geometryFactory == null) {
            geometryFactory = new GeometryFactory();
        }
        return geometryFactory;
    }

    protected FIDFeatureReader createFeatureReader(String string, ShapefileAttributeReader shapefileAttributeReader, SimpleFeatureType simpleFeatureType) throws SchemaException {
        return new FIDFeatureReader(shapefileAttributeReader, new ShapeFIDReader(simpleFeatureType, shapefileAttributeReader), simpleFeatureType);
    }

    protected ShapefileAttributeReader getAttributesReader(boolean bl, Query query) throws IOException {
        ShapefileAttributeReader shapefileAttributeReader;
        List<AttributeDescriptor> list = this.schema == null ? this.readAttributes() : this.schema.getAttributeDescriptors();
        GeometryFactory geometryFactory = query != null ? this.getGeometryFactory(query.getHints()) : new GeometryFactory();
        ShapefileReader shapefileReader = this.openShapeReader(geometryFactory);
        if (!bl) {
            LOGGER.fine("The DBF file won't be opened since no attributes will be read from it");
            list = new ArrayList<AttributeDescriptor>(1);
            list.add(this.schema.getGeometryDescriptor());
            shapefileAttributeReader = new ShapefileAttributeReader(list, shapefileReader, null);
        } else {
            shapefileAttributeReader = new ShapefileAttributeReader(list, shapefileReader, this.openDbfReader());
        }
        if (query != null) {
            Hints hints;
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope();
            referencedEnvelope = (Envelope)query.getFilter().accept(ExtractBoundsFilterVisitor.BOUNDS_VISITOR, referencedEnvelope);
            if (referencedEnvelope != null && !referencedEnvelope.isNull()) {
                shapefileAttributeReader.setTargetBBox(referencedEnvelope);
            }
            if ((hints = query.getHints()) != null) {
                Number number = (Number)hints.get(Hints.GEOMETRY_DISTANCE);
                if (number != null) {
                    shapefileAttributeReader.setSimplificationDistance(number.doubleValue());
                }
                if (Boolean.TRUE.equals(hints.get(Hints.FEATURE_2D))) {
                    shapefileReader.setFlatGeometry(true);
                }
            }
        }
        return shapefileAttributeReader;
    }

    protected ShapefileReader openShapeReader(GeometryFactory geometryFactory) throws IOException {
        try {
            return new ShapefileReader(this.shpFiles, true, this.useMemoryMappedBuffer, geometryFactory);
        }
        catch (ShapefileException shapefileException) {
            throw new DataSourceException("Error creating ShapefileReader", shapefileException);
        }
    }

    protected DbaseFileReader openDbfReader() throws IOException {
        if (this.shpFiles.get(ShpFileType.DBF) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.DBF)) {
            return null;
        }
        try {
            return new DbaseFileReader(this.shpFiles, this.useMemoryMappedBuffer, this.dbfCharset, this.dbfTimeZone);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected IndexFile openIndexFile() throws IOException {
        if (this.shpFiles.get(ShpFileType.SHX) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.SHX)) {
            return null;
        }
        try {
            return new IndexFile(this.shpFiles, this.useMemoryMappedBuffer);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected PrjFileReader openPrjReader() throws IOException, FactoryException {
        if (this.shpFiles.get(ShpFileType.PRJ) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.PRJ)) {
            return null;
        }
        try {
            return new PrjFileReader(this.shpFiles);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String[] getTypeNames() {
        return new String[]{this.getCurrentTypeName()};
    }

    protected String createFeatureTypeName() {
        return this.shpFiles.getTypeName();
    }

    protected String getCurrentTypeName() {
        return this.schema == null ? this.createFeatureTypeName() : this.schema.getTypeName();
    }

    protected void typeCheck(String string) throws IOException {
        if (!this.getCurrentTypeName().equals(string)) {
            throw new IOException("No such type : " + string);
        }
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String string, Transaction transaction) throws IOException {
        return null;
    }

    @Override
    public SimpleFeatureType getSchema(String string) throws IOException {
        this.typeCheck(string);
        return this.getSchema();
    }

    @Override
    public SimpleFeatureType getSchema() throws IOException {
        if (this.schema == null) {
            List<AttributeDescriptor> list = this.readAttributes();
            SimpleFeatureType simpleFeatureType = null;
            GeometryDescriptor geometryDescriptor = (GeometryDescriptor)list.get(0);
            Class<?> clazz = geometryDescriptor.getType().getBinding();
            if (clazz == Point.class || clazz == MultiPoint.class) {
                simpleFeatureType = BasicFeatureTypes.POINT;
            } else if (clazz == Polygon.class || clazz == MultiPolygon.class) {
                simpleFeatureType = BasicFeatureTypes.POLYGON;
            } else if (clazz == LineString.class || clazz == MultiLineString.class) {
                simpleFeatureType = BasicFeatureTypes.LINE;
            }
            SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
            simpleFeatureTypeBuilder.setDefaultGeometry(geometryDescriptor.getLocalName());
            simpleFeatureTypeBuilder.addAll(list);
            simpleFeatureTypeBuilder.setName(this.createFeatureTypeName());
            if (this.namespace != null) {
                simpleFeatureTypeBuilder.setNamespaceURI(this.namespace);
            } else {
                simpleFeatureTypeBuilder.setNamespaceURI("http://www.opengis.net/gml");
            }
            simpleFeatureTypeBuilder.setAbstract(false);
            if (simpleFeatureType != null) {
                simpleFeatureTypeBuilder.setSuperType(simpleFeatureType);
            }
            this.schema = simpleFeatureTypeBuilder.buildFeatureType();
        }
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AttributeDescriptor> readAttributes() throws IOException {
        ShapefileReader shapefileReader = this.openShapeReader(new GeometryFactory());
        DbaseFileReader dbaseFileReader = this.openDbfReader();
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        PrjFileReader prjFileReader = null;
        try {
            prjFileReader = this.openPrjReader();
            if (prjFileReader != null) {
                coordinateReferenceSystem = prjFileReader.getCoodinateSystem();
            }
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        ArrayList<AttributeDescriptor> arrayList = new ArrayList<AttributeDescriptor>();
        try {
            Object object;
            Class clazz = JTSUtilities.findBestGeometryClass(shapefileReader.getHeader().getShapeType());
            attributeTypeBuilder.setName(Classes.getShortName(clazz));
            attributeTypeBuilder.setNillable(true);
            attributeTypeBuilder.setCRS(coordinateReferenceSystem);
            attributeTypeBuilder.setBinding(clazz);
            GeometryType geometryType = attributeTypeBuilder.buildGeometryType();
            arrayList.add(attributeTypeBuilder.buildDescriptor("the_geom", geometryType));
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("the_geom");
            if (dbaseFileReader != null) {
                object = dbaseFileReader.getHeader();
                int n = ((DbaseFileHeader)object).getNumFields();
                for (int i = 0; i < n; ++i) {
                    Class clazz2 = ((DbaseFileHeader)object).getFieldClass(i);
                    String string = ((DbaseFileHeader)object).getFieldName(i);
                    if (hashSet.contains(string)) {
                        String string2 = string;
                        int n2 = 1;
                        string = string + n2;
                        while (hashSet.contains(string)) {
                            string = string2 + ++n2;
                        }
                        attributeTypeBuilder.addUserData(ORIGINAL_FIELD_NAME, string2);
                        attributeTypeBuilder.addUserData(ORIGINAL_FIELD_DUPLICITY_COUNT, n2);
                    }
                    hashSet.add(string);
                    int n3 = ((DbaseFileHeader)object).getFieldLength(i);
                    attributeTypeBuilder.setNillable(true);
                    attributeTypeBuilder.setLength(n3);
                    attributeTypeBuilder.setBinding(clazz2);
                    arrayList.add(attributeTypeBuilder.buildDescriptor(string));
                }
            }
            object = arrayList;
            return object;
        }
        finally {
            try {
                if (prjFileReader != null) {
                    prjFileReader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (dbaseFileReader != null) {
                    dbaseFileReader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (shapefileReader != null) {
                    shapefileReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ReferencedEnvelope getBounds() throws DataSourceException {
        Envelope envelope;
        Channel channel;
        block17: {
            channel = null;
            ByteBuffer byteBuffer = ByteBuffer.allocate(100);
            FileReader fileReader = new FileReader(){};
            channel = this.shpFiles.getReadChannel(ShpFileType.SHP, fileReader);
            channel.read(byteBuffer);
            byteBuffer.flip();
            ShapefileHeader shapefileHeader = new ShapefileHeader();
            shapefileHeader.read(byteBuffer, true);
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(this.schema.getCoordinateReferenceSystem());
            referencedEnvelope.include(shapefileHeader.minX(), shapefileHeader.minY());
            referencedEnvelope.include(shapefileHeader.minX(), shapefileHeader.minY());
            envelope = new Envelope(shapefileHeader.minX(), shapefileHeader.maxX(), shapefileHeader.minY(), shapefileHeader.maxY());
            if (this.schema == null) break block17;
            ReferencedEnvelope referencedEnvelope2 = new ReferencedEnvelope(envelope, this.schema.getCoordinateReferenceSystem());
            channel.close();
            return referencedEnvelope2;
        }
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(envelope, null);
        channel.close();
        return referencedEnvelope;
        {
            catch (Throwable throwable) {
                try {
                    channel.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new DataSourceException("Problem getting Bbox", iOException);
                }
            }
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        if (query.getFilter().equals(Filter.INCLUDE)) {
            return this.getBounds();
        }
        return null;
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String string) throws IOException {
        SimpleFeatureType simpleFeatureType = this.getSchema(string);
        if (this.isWriteable) {
            if (this.getLockingManager() != null) {
                return new ShapefileFeatureLocking(this, this.getSupportedHints(), simpleFeatureType);
            }
            return new ShapefileFeatureStore(this, this.getSupportedHints(), simpleFeatureType);
        }
        return new ShapefileFeatureSource(this, this.getSupportedHints(), simpleFeatureType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            IndexFile indexFile = this.openIndexFile();
            if (indexFile != null) {
                try {
                    int n = indexFile.getRecordCount();
                    return n;
                }
                finally {
                    indexFile.close();
                }
            }
            ShapefileReader shapefileReader = this.openShapeReader(new GeometryFactory());
            int n = -1;
            try {
                n = shapefileReader.getCount(n);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                shapefileReader.close();
            }
            return n;
        }
        return super.getCount(query);
    }

    public String toString() {
        return "Shapefile datastore for :" + this.shpFiles.get(ShpFileType.SHP);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.shpFiles != null) {
            this.shpFiles.dispose();
            this.shpFiles = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.shpFiles != null && this.trace != null) {
            LOGGER.log(Level.SEVERE, "Undisposed of shapefile, you should call dispose() on all shapefile stores", this.trace);
        }
        this.dispose();
    }

    @Override
    protected Set getSupportedHints() {
        HashSet<Hints.Key> hashSet = new HashSet<Hints.Key>();
        hashSet.add(Hints.FEATURE_DETACHED);
        hashSet.add(Hints.JTS_GEOMETRY_FACTORY);
        hashSet.add(Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
        hashSet.add(Hints.GEOMETRY_DISTANCE);
        return hashSet;
    }
}

