/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.AttributeReader;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FIDFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private final AttributeReader attributeReader;
    private final SimpleFeatureType schema;
    private final FIDReader fidReader;
    private SimpleFeatureBuilder builder;
    private Boolean hasNextFlag;

    public FIDFeatureReader(AttributeReader attributeReader, FIDReader fIDReader, SimpleFeatureType simpleFeatureType) throws SchemaException {
        this.attributeReader = attributeReader;
        this.fidReader = fIDReader;
        if (simpleFeatureType == null) {
            simpleFeatureType = this.createSchema();
        }
        this.schema = simpleFeatureType;
        this.builder = new SimpleFeatureBuilder(simpleFeatureType);
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.hasNext()) {
            this.hasNextFlag = null;
            this.attributeReader.next();
            return this.readFeature(this.attributeReader);
        }
        throw new NoSuchElementException("There are no more Features to be read");
    }

    protected SimpleFeatureType createSchema() throws SchemaException {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName("xxx");
        int n = this.attributeReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            simpleFeatureTypeBuilder.add(this.attributeReader.getAttributeType(i));
        }
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    protected SimpleFeature readFeature(AttributeReader attributeReader) throws IllegalAttributeException, IOException {
        String string = this.fidReader.next();
        int n = attributeReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            this.builder.add(attributeReader.read(i));
        }
        return this.builder.buildFeature(string);
    }

    @Override
    public void close() throws IOException {
        this.fidReader.close();
        this.attributeReader.close();
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.hasNextFlag == null) {
            this.hasNextFlag = this.attributeReader.hasNext();
        }
        return this.hasNextFlag;
    }
}

