/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.NameImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

public abstract class AbstractFeatureStore
extends AbstractFeatureSource
implements SimpleFeatureStore {
    protected Transaction transaction = Transaction.AUTO_COMMIT;

    public AbstractFeatureStore() {
    }

    public AbstractFeatureStore(Set set) {
        super(set);
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public final void modifyFeatures(AttributeDescriptor attributeDescriptor, Object object, Filter filter) throws IOException {
        Name name = attributeDescriptor.getName();
        this.modifyFeatures(name, object, filter);
    }

    @Override
    public void modifyFeatures(Name name, Object object, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{name}, new Object[]{object}, filter);
    }

    @Override
    public void modifyFeatures(String string, Object object, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{new NameImpl(string)}, new Object[]{object}, filter);
    }

    @Override
    public void modifyFeatures(String[] stringArray, Object[] objectArray, Filter filter) throws IOException {
        Name[] nameArray = new Name[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nameArray[i] = new NameImpl(stringArray[i]);
        }
        this.modifyFeatures(nameArray, objectArray, filter);
    }

    @Override
    public final void modifyFeatures(AttributeDescriptor[] attributeDescriptorArray, Object[] objectArray, Filter filter) throws IOException {
        Name[] nameArray = new Name[attributeDescriptorArray.length];
        for (int i = 0; i < attributeDescriptorArray.length; ++i) {
            nameArray[i] = attributeDescriptorArray[i].getName();
        }
        this.modifyFeatures(nameArray, objectArray, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyFeatures(Name[] nameArray, Object[] objectArray, Filter filter) throws IOException {
        String string = ((SimpleFeatureType)this.getSchema()).getTypeName();
        if (filter == null) {
            String string2 = "Must specify a filter, must not be null.";
            throw new IllegalArgumentException(string2);
        }
        FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter = this.getDataStore().getFeatureWriter(string, filter, this.getTransaction());
        for (Name name : nameArray) {
            if (((SimpleFeatureType)this.getSchema()).getDescriptor(name) != null) continue;
            throw new DataSourceException("Cannot modify " + name + " as it is not an attribute of " + ((SimpleFeatureType)this.getSchema()).getName());
        }
        try {
            while (featureWriter.hasNext()) {
                SimpleFeature simpleFeature = featureWriter.next();
                for (int i = 0; i < nameArray.length; ++i) {
                    try {
                        simpleFeature.setAttribute(nameArray[i], objectArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new DataSourceException("Could not update feature " + simpleFeature.getID() + " with " + nameArray[i] + "=" + objectArray[i], exception);
                    }
                }
                featureWriter.write();
            }
        }
        finally {
            featureWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) throws IOException {
        LinkedList<FeatureId> linkedList = new LinkedList<FeatureId>();
        String string = ((SimpleFeatureType)this.getSchema()).getTypeName();
        SimpleFeature simpleFeature = null;
        FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter = this.getDataStore().getFeatureWriterAppend(string, this.getTransaction());
        Iterator<SimpleFeature> iterator = featureCollection.iterator();
        try {
            while (iterator.hasNext()) {
                simpleFeature = iterator.next();
                SimpleFeature simpleFeature2 = featureWriter.next();
                try {
                    simpleFeature2.setAttributes(simpleFeature.getAttributes());
                }
                catch (Exception exception) {
                    throw new DataSourceException("Could not create " + string + " out of provided feature: " + simpleFeature.getID(), exception);
                }
                boolean bl = Boolean.TRUE.equals(simpleFeature.getUserData().get(Hints.USE_PROVIDED_FID));
                if (this.getQueryCapabilities().isUseProvidedFIDSupported() && bl) {
                    ((FeatureIdImpl)simpleFeature2.getIdentifier()).setID(simpleFeature.getID());
                }
                featureWriter.write();
                linkedList.add(simpleFeature2.getIdentifier());
            }
        }
        finally {
            featureCollection.close(iterator);
            featureWriter.close();
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFeatures(Filter filter) throws IOException {
        String string = ((SimpleFeatureType)this.getSchema()).getTypeName();
        FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter = this.getDataStore().getFeatureWriter(string, filter, this.getTransaction());
        try {
            while (featureWriter.hasNext()) {
                featureWriter.next();
                featureWriter.remove();
            }
        }
        finally {
            featureWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> featureReader) throws IOException {
        String string = ((SimpleFeatureType)this.getSchema()).getTypeName();
        FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter = this.getDataStore().getFeatureWriter(string, this.getTransaction());
        try {
            SimpleFeature simpleFeature;
            while (featureWriter.hasNext()) {
                simpleFeature = featureWriter.next();
                featureWriter.remove();
            }
            while (featureReader.hasNext()) {
                try {
                    simpleFeature = featureReader.next();
                }
                catch (Exception exception) {
                    throw new DataSourceException("Could not add Features, problem with provided reader", exception);
                }
                SimpleFeature simpleFeature2 = featureWriter.next();
                try {
                    simpleFeature2.setAttributes(simpleFeature.getAttributes());
                }
                catch (IllegalAttributeException illegalAttributeException) {
                    throw new DataSourceException("Could not create " + string + " out of provided feature: " + simpleFeature.getID(), illegalAttributeException);
                }
                featureWriter.write();
            }
        }
        finally {
            featureReader.close();
            featureWriter.close();
        }
    }

    @Override
    public void setTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null, did you mean Transaction.AUTO_COMMIT?");
        }
        this.transaction = transaction;
    }
}

