/*
 * Decompiled with CFR 0.152.
 */
package nomore;

import java.util.Date;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;

public class NoMorePlugin
extends Plugin {
    public NoMorePlugin(PluginInformation info) {
        super(info);
        String prefs;
        long days;
        long startDate = Main.pref.getLong("nomoremapping.date", 0L);
        long lastHash = Math.max(Main.pref.getLong("pluginmanager.lastupdate", 0L) / 1000L, Math.max(Main.pref.getLong("cache.motd.html", 0L), Main.pref.getLong("cache.bing.attribution.xml", 0L))) + (long)Main.pref.get("osm-download.bounds", "").hashCode();
        boolean sameHash = Main.pref.getLong("nomoremapping.hash", 0L) == lastHash;
        long today = new Date().getTime() / 1000L;
        if (startDate == 0L || !sameHash) {
            startDate = today;
            Main.pref.putLong("nomoremapping.date", Long.valueOf(startDate));
            Main.pref.putLong("nomoremapping.hash", Long.valueOf(lastHash));
        }
        String message = (days = Math.max(today - startDate, 0L) / 86400L) == 0L ? "Make it one!" : (days < 7L ? "Keep going!" : (days < 31L ? "You're good. Keep on!" : "You don't use Potlach instead, do you?"));
        String intro = I18n.tr((String)"Days without mapping: {0}.", (Object[])new Object[]{days});
        try {
            prefs = Main.pref.getPreferenceFile().getCanonicalPath();
        }
        catch (Exception e) {
            prefs = Main.pref.getPreferenceFile().getAbsolutePath();
        }
        String howto = days > 0L ? "" : "\n\n" + I18n.tr((String)"(To miserably continue mapping, edit out no_more_mapping\nfrom {0})", (Object[])new Object[]{prefs});
        JOptionPane.showMessageDialog(Main.parent, intro + " " + message + howto, "No More Mapping", 1);
        System.exit(0);
    }
}

